/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class DWServiceContext {
    private static ThreadLocal<DWServiceContext> _currentContext = new ThreadLocal();
    private String _uuid = null;
    private Map<String, Object> _profile = null;
    private String _moduleName = null;
    private List<Long> _durations = new ArrayList<Long>();
    private boolean _async = false;
    private transient Future<?> _future = null;
    private String _token = null;
    private Map<String, Object> _requestHeader = new HashMap<String, Object>();
    private Map<String, Object> _responseHeader = new HashMap<String, Object>();
    private boolean _standardResult = true;
    private boolean _disableResultHandler = true;
    private String traceId;

    public static DWServiceContext getContext() {
        DWServiceContext context = _currentContext.get();
        if (context == null) {
            context = new DWServiceContext();
            _currentContext.set(context);
        }
        return context;
    }

    public static void setContext(DWServiceContext serviceContext) {
        _currentContext.set(serviceContext);
    }

    public String getUUID() {
        return this._uuid;
    }

    public void setUUID(String uuid) {
        this._uuid = uuid;
    }

    public Map<String, Object> getProfile() {
        return this._profile;
    }

    public void setProfile(Map<String, Object> profile) {
        this._profile = profile;
    }

    public long getDuration() {
        if (this._durations != null && this._durations.size() > 0) {
            return this._durations.get(this._durations.size() - 1);
        }
        return 0L;
    }

    public List<Long> getDurations() {
        return Collections.unmodifiableList(this._durations);
    }

    public void pushDuration(long duration) {
        this._durations.add(duration);
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }

    public boolean isAsync() {
        return this._async;
    }

    public void setAsync(boolean async) {
        this._async = async;
    }

    public void setFuture(Future<?> future) {
        this._future = future;
    }

    public Future<?> getFuture() {
        return this._future;
    }

    public String getToken() {
        return this._token;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public Map<String, Object> getRequestHeader() {
        return this._requestHeader;
    }

    public void setRequestHeader(Map<String, Object> requestHeader) {
        this._requestHeader = requestHeader;
    }

    public Map<String, Object> getResponseHeader() {
        return this._responseHeader;
    }

    public void setResponseHeader(Map<String, Object> responseHeader) {
        this._responseHeader = responseHeader;
    }

    public boolean getStandardResult() {
        return this._standardResult;
    }

    public void setStandardResult(boolean _standardResult) {
        this._standardResult = _standardResult;
    }

    public boolean getResultHandlerEnabled() {
        return this._disableResultHandler;
    }

    public void disableResultHandler() {
        this._disableResultHandler = false;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void clear() {
        this._uuid = null;
        this._moduleName = null;
        this._profile = null;
        this._durations.clear();
        this._async = false;
        this._future = null;
        this._token = null;
        this._requestHeader = new HashMap<String, Object>();
        this._responseHeader = new HashMap<String, Object>();
        this._standardResult = true;
        this._disableResultHandler = true;
        this.traceId = null;
    }
}

