/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigPool;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWResourceUtils {
    private static Log _log = LogFactory.getLog(DWResourceUtils.class);
    private static ConfigPool pool = ConfigPool.getInstance();

    public static File getResource(String path) {
        return DWResourceUtils.getResource(path, "");
    }

    public static File getResource(String path, String resourceName) {
        String resourcePath = path + File.separator + resourceName;
        File resource = new File(resourcePath);
        return resource;
    }

    public static String getResourceString(String path, String resourceName) {
        String resourcePath = path + File.separator + resourceName;
        StringBuilder stringBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(resourcePath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> stringBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            _log.error((Object)("getResourceString failed! FileName=" + path + ", error message=" + e.getMessage()));
            return null;
        }
        String content = stringBuilder.toString();
        return content;
    }

    public static File getPlatformResource(String resourceName) {
        String path = DWPathUtils.getPlatformConfPath();
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getPlatformResourceString(String resourceName) {
        String path = DWPathUtils.getPlatformConfPath();
        return DWResourceUtils.getResourceString(path, resourceName);
    }

    public static File getPlatformModuleResource(String resourceName, String moduleName) {
        String path = DWPathUtils.getPlatformModuleConfPath(moduleName);
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getPlatformModuleResourceString(String resourceName, String moduleName) {
        String path = DWPathUtils.getPlatformModuleConfPath(moduleName);
        return DWResourceUtils.getResourceString(path, resourceName);
    }

    public static File getApplicationResource(String resourceName) {
        String path = DWPathUtils.getApplicationConfPath();
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getApplicationResourceString(String resourceName) {
        String content = pool.getApplicationResource(resourceName);
        return content;
    }

    public static File getApplicationModuleResource(String resourceName, String moduleName) {
        String path = DWPathUtils.getApplicationModuleConfPath(moduleName);
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getApplicationModuleResourceString(String resourceName, String moduleName) {
        String content = pool.getModuleResource(moduleName, resourceName);
        return content;
    }

    public static File getIndustryResource(String resourceName) {
        String path = DWPathUtils.getIndustryConfPath();
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getIndustryResourceString(String resourceName) {
        String path = DWPathUtils.getIndustryConfPath();
        return DWResourceUtils.getResourceString(path, resourceName);
    }

    public static File getIndustryModuleResource(String resourceName, String moduleName) {
        String path = DWPathUtils.getIndustryModuleConfPath(moduleName);
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getIndustryModuleResourceString(String resourceName, String moduleName) {
        String path = DWPathUtils.getIndustryModuleConfPath(moduleName);
        return DWResourceUtils.getResourceString(path, resourceName);
    }

    public static File getCustomizationResource(String resourceName) {
        String path = DWPathUtils.getCustomizationConfPath();
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getCustomizationResourceString(String resourceName) {
        String path = DWPathUtils.getCustomizationConfPath();
        return DWResourceUtils.getResourceString(path, resourceName);
    }

    public static File getCustomizationModuleResource(String resourceName, String moduleName) {
        String path = DWPathUtils.getCustomizationModuleConfPath(moduleName);
        return DWResourceUtils.getResource(path, resourceName);
    }

    public static String getCustomizationModuleResourceString(String resourceName, String moduleName) {
        String path = DWPathUtils.getCustomizationModuleConfPath(moduleName);
        return DWResourceUtils.getResourceString(path, resourceName);
    }
}

