/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.local;

import com.digiwin.app.adapter.ResourceBundleAdapter;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.reader.BaseReader;
import com.digiwin.app.common.config.reader.resource.LocaleReader;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalReader
implements BaseReader {
    private static final String TAG = "[LocalReader] ";
    private static Log _log = LogFactory.getLog(LocalReader.class);

    @Override
    public String getLog4j2Xml() {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + "log4j2.xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getPlatformModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String path = DWPathUtils.getPlatformModuleConfPath(module) + File.separator + xmlNameWithoutExtension + ".xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String path = DWPathUtils.getApplicationModuleConfPath(module) + File.separator + xmlNameWithoutExtension + ".xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getApplicationSpringXml(String xmlNameWithoutExtension) {
        String path = DWPathUtils.getApplicationConfPath() + File.separator + xmlNameWithoutExtension + ".xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getPlatformSpringXml(String xmlNameWithoutExtension) {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + xmlNameWithoutExtension + ".xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getModuleResource(String module, String nameWithoutExtension, Extension extension) {
        String path = DWPathUtils.getApplicationModuleConfPath(module) + File.separator + nameWithoutExtension + "." + extension.getValue();
        String resourceString = this.loadFileContent(path);
        return resourceString;
    }

    @Override
    public String getApplicationResource(String nameWithoutExtension, Extension extension) {
        String path = DWPathUtils.getApplicationConfPath() + File.separator + nameWithoutExtension + "." + extension.getValue();
        String resourceString = this.loadFileContent(path);
        return resourceString;
    }

    @Override
    public Properties getProperties(String path, String propertiesNameWithoutExtension) {
        Properties properties = null;
        String fileFullName = path + File.separator + propertiesNameWithoutExtension + ".properties";
        File propertiesFile = new File(fileFullName);
        if (propertiesFile.exists()) {
            URL url = null;
            try {
                url = propertiesFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                _log.error((Object)("[LocalReader] LocalReader getProperties failed! FileName=" + fileFullName + ", MalformedURLException: message=" + malformedURLException.getMessage()));
                return null;
            }
            if (url != null) {
                try (InputStream propertyInputStream = url.openStream();){
                    properties = new Properties();
                    properties.load(propertyInputStream);
                }
                catch (IOException ioException) {
                    _log.error((Object)("[LocalReader] LocalReader getProperties failed! FileName=" + fileFullName + ", IOException: message=" + ioException.getMessage()));
                    return null;
                }
            }
        }
        return properties;
    }

    @Override
    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        ClassLoader platformClassLoader = DWApplicationClassLoader.getInstance().getPlatformClassLoader();
        String result = this.getString(platformClassLoader, baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
        return result;
    }

    @Override
    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        DWApplicationClassLoader applicationClassLoader = DWApplicationClassLoader.getInstance();
        String result = this.getString((ClassLoader)((Object)applicationClassLoader), baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
        return result;
    }

    @Override
    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
        String result = this.getString((ClassLoader)((Object)moduleClassLoader), baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
        return result;
    }

    @Override
    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        ResourceBundle rb = null;
        String result = null;
        try {
            rb = ResourceBundle.getBundle(baseName, locale, cl);
            if (rb != null) {
                result = rb.getString(key);
            }
        }
        catch (MissingResourceException exception) {
            _log.debug((Object)(LocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            ResourceBundleAdapter resourceBundleAdapter = null;
            try {
                resourceBundleAdapter = (ResourceBundleAdapter)SpringContextUtils.getBean((String)"resourceBundleAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourceBundleAdapter != null) {
                result = resourceBundleAdapter.getMessage(key, patternArguments, locale);
            }
        }
        if (result == null) {
            return null;
        }
        if (patternArguments != null) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    private String loadFileContent(String path) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!new File(path).exists()) {
            return null;
        }
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> stringBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            _log.error((Object)("[LocalReader] LocalReader loadFileContent failed! FileName=" + path + ", IOException: message=" + e.getMessage()));
            return null;
        }
        String content = stringBuilder.toString();
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        return content;
    }
}

