/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class DWFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean loadedFromInputStream = false;
    private InputStream inputStream;
    private String fileName;
    private byte[] fileByteArray;
    @Deprecated
    private String fileByteArrayString;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        this.inputStream = inputStream;
        this.loadedFromInputStream = false;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getFileByteArray() throws Exception {
        if (!this.loadedFromInputStream && this.inputStream != null) {
            this.fileByteArray = this.toByteArray(this.getInputStream());
            this.loadedFromInputStream = true;
        }
        return this.fileByteArray;
    }

    public String getFileByteArrayString() throws Exception {
        return Arrays.toString(this.getFileByteArray());
    }

    public int getFileSize() throws Exception {
        return this.getFileByteArray().length;
    }

    @Deprecated
    public void setByteArray(byte[] byteArray) throws Exception {
        this.fileByteArrayString = Arrays.toString(byteArray);
    }

    public byte[] toByteArray(InputStream input) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.copy(input, output);
        return output.toByteArray();
    }

    private int copy(InputStream input, OutputStream output) throws Exception {
        long count = this.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private long copyLarge(InputStream input, OutputStream output) throws Exception {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

