/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.service.DWFilter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DWFilterUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final ScriptEngine scriptEngine;

    protected void copyInputStream(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            this.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            this.copy(in, output);
        }
    }

    private void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        this.copy(in, output);
    }

    private int copy(Reader input, Writer output) throws IOException {
        long count = this.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    protected Map<?, ?> parseJson(String jsonString) throws Exception {
        String eval = "new java.util.concurrent.atomic.AtomicReference(toJava(" + jsonString + "))";
        AtomicReference ret = (AtomicReference)scriptEngine.eval(eval);
        return (Map)ret.get();
    }

    static {
        try {
            String inputLine;
            StringBuilder stringBuilder = new StringBuilder();
            String urlString = URLDecoder.decode(DWFilter.class.getResource("json2java.js").toString(), "UTF-8");
            URL url = new URL(urlString);
            URLConnection urlConnection = url.openConnection();
            InputStreamReader inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((inputLine = bufferedReader.readLine()) != null) {
                stringBuilder.append(inputLine);
            }
            bufferedReader.close();
            String json2java = stringBuilder.toString();
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
            engine.eval(json2java);
            scriptEngine = engine;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private class DWServletOutputStream
    extends ServletOutputStream {
        StringBuilder stringBuilder = new StringBuilder();

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stringBuilder.append(new String(b, off, len, "UTF-8"));
        }

        public String toString() {
            return this.stringBuilder.toString();
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
        }
    }

    protected class ContentCachingResponse
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private int httpStatus;
        private String contentType;

        public ContentCachingResponse(HttpServletResponse response) throws IOException {
            super(response);
            this.outputStream = new DWServletOutputStream();
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, "UTF-8"));
        }
    }

    protected class ContentCachingRequest
    extends HttpServletRequestWrapper {
        private String _body;
        private Map<String, String[]> modifiableParameters;
        private Map<String, String[]> allParameters;

        public ContentCachingRequest(HttpServletRequest request) throws IOException {
            String line;
            super(request);
            this._body = "";
            this.modifiableParameters = new TreeMap<String, String[]>();
            this.allParameters = null;
            BufferedReader bufferedReader = request.getReader();
            while ((line = bufferedReader.readLine()) != null) {
                this._body = this._body + line;
            }
        }

        public void addParameter(String key, String[] values) {
            this.modifiableParameters.put(key, values);
        }

        public String getParameter(String name) {
            String[] strings = this.getParameterMap().get(name);
            if (strings != null) {
                return strings[0];
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            if (this.allParameters == null) {
                this.allParameters = new TreeMap<String, String[]>();
                this.allParameters.putAll(super.getParameterMap());
                this.allParameters.putAll(this.modifiableParameters);
            }
            return Collections.unmodifiableMap(this.allParameters);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }

        public String[] getParameterValues(String name) {
            return this.getParameterMap().get(name);
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._body.getBytes());
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener arg0) {
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
    }
}

