/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.ExtensionUtils;
import com.digiwin.app.common.config.local.LocalReader;
import com.digiwin.app.common.config.remote.GroupReader;
import com.digiwin.app.common.config.remote.RemoteReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ConfigPool {
    private static final String TAG = "[ConfigPool] ";
    private static ConfigPool instance;
    private ConfigPolicy policy = ConfigPolicy.LOCAL_FIRST;
    private boolean isRemoteConfigOn = false;
    private boolean isGroupConfigOn = false;
    private LocalReader local = new LocalReader();
    private RemoteReader remote = new RemoteReader();
    private GroupReader group = new GroupReader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigPool getInstance() {
        if (instance != null) return instance;
        Class<ConfigPool> clazz = ConfigPool.class;
        synchronized (ConfigPool.class) {
            if (instance != null) return instance;
            instance = new ConfigPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(ConfigPolicy policy, boolean isRemoteConfigOn, boolean isGroupConfigOn) {
        instance.setSetting(policy, isRemoteConfigOn, isGroupConfigOn);
    }

    public String toString() {
        return "[ConfigPool] policy: " + (Object)((Object)this.policy) + ", isRemoteConfigOn: " + this.isRemoteConfigOn + ", isGroupConfigOn: " + this.isGroupConfigOn;
    }

    public String getLog4j2Xml() {
        String xmlString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            xmlString = this.local.getLog4j2Xml();
            if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                return xmlString;
            }
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getLog4j2Xml();
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn) {
                    xmlString = this.group.getGroupLog4j2Xml();
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getLog4j2Xml();
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn && StringUtils.isNotBlank((CharSequence)(xmlString = this.group.getGroupLog4j2Xml()))) {
                    return xmlString;
                }
            }
            xmlString = this.local.getLog4j2Xml();
        }
        return xmlString;
    }

    public String getModuleSpringXml(String module, String xmlName) {
        String xmlNameWithoutExtension = ExtensionUtils.getNameWithoutExtension(xmlName);
        String xmlString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            xmlString = this.local.getModuleSpringXml(module, xmlNameWithoutExtension);
            if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                return xmlString;
            }
            xmlString = this.local.getPlatformModuleSpringXml(module, xmlNameWithoutExtension);
            if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                return xmlString;
            }
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getModuleSpringXml(module, xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                xmlString = this.remote.getPlatformModuleSpringXml(module, xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn) {
                    xmlString = this.group.getGroupModuleSpringXml(xmlNameWithoutExtension);
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getModuleSpringXml(module, xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                xmlString = this.remote.getPlatformModuleSpringXml(module, xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn && StringUtils.isNotBlank((CharSequence)(xmlString = this.group.getGroupModuleSpringXml(xmlNameWithoutExtension)))) {
                    return xmlString;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(xmlString = this.local.getModuleSpringXml(module, xmlNameWithoutExtension)))) {
                return xmlString;
            }
            xmlString = this.local.getPlatformModuleSpringXml(module, xmlNameWithoutExtension);
        }
        return xmlString;
    }

    public String getModuleResource(String module, String resourceName) {
        String nameWithoutExtension = ExtensionUtils.getNameWithoutExtension(resourceName);
        String extension = ExtensionUtils.getFileExtension(resourceName);
        String resourceString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            resourceString = this.local.getModuleResource(module, nameWithoutExtension, Extension.fromString(extension));
            if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                return resourceString;
            }
            if (this.isRemoteConfigOn) {
                resourceString = this.remote.getModuleResource(module, nameWithoutExtension, Extension.fromString(extension));
                if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                    return resourceString;
                }
                if (this.isGroupConfigOn) {
                    resourceString = this.group.getGroupModuleResource(nameWithoutExtension, Extension.fromString(extension));
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                resourceString = this.remote.getModuleResource(module, nameWithoutExtension, Extension.fromString(extension));
                if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                    return resourceString;
                }
                if (this.isGroupConfigOn && StringUtils.isNotBlank((CharSequence)(resourceString = this.group.getGroupModuleResource(nameWithoutExtension, Extension.fromString(extension))))) {
                    return resourceString;
                }
            }
            resourceString = this.local.getModuleResource(module, nameWithoutExtension, Extension.fromString(extension));
        }
        return resourceString;
    }

    public String getApplicationSpringXml(String xmlName) {
        String xmlNameWithoutExtension = ExtensionUtils.getNameWithoutExtension(xmlName);
        String xmlString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            xmlString = this.local.getApplicationSpringXml(xmlNameWithoutExtension);
            if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                return xmlString;
            }
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getApplicationSpringXml(xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn) {
                    xmlString = this.group.getGroupApplicationSpringXml(xmlNameWithoutExtension);
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getApplicationSpringXml(xmlNameWithoutExtension);
                if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                    return xmlString;
                }
                if (this.isGroupConfigOn && StringUtils.isNotBlank((CharSequence)(xmlString = this.group.getGroupApplicationSpringXml(xmlNameWithoutExtension)))) {
                    return xmlString;
                }
            }
            xmlString = this.local.getApplicationSpringXml(xmlNameWithoutExtension);
        }
        return xmlString;
    }

    public String getApplicationResource(String resourceName) {
        String nameWithoutExtension = ExtensionUtils.getNameWithoutExtension(resourceName);
        String extension = ExtensionUtils.getFileExtension(resourceName);
        String resourceString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            resourceString = this.local.getApplicationResource(nameWithoutExtension, Extension.fromString(extension));
            if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                return resourceString;
            }
            if (this.isRemoteConfigOn) {
                resourceString = this.remote.getApplicationResource(nameWithoutExtension, Extension.fromString(extension));
                if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                    return resourceString;
                }
                if (this.isGroupConfigOn) {
                    resourceString = this.group.getGroupApplicationResource(nameWithoutExtension, Extension.fromString(extension));
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                resourceString = this.remote.getApplicationResource(nameWithoutExtension, Extension.fromString(extension));
                if (StringUtils.isNotBlank((CharSequence)resourceString)) {
                    return resourceString;
                }
                if (this.isGroupConfigOn && StringUtils.isNotBlank((CharSequence)(resourceString = this.group.getGroupApplicationResource(nameWithoutExtension, Extension.fromString(extension))))) {
                    return resourceString;
                }
            }
            resourceString = this.local.getApplicationResource(nameWithoutExtension, Extension.fromString(extension));
        }
        return resourceString;
    }

    public String getPlatformSpringXml(String xmlName) {
        String xmlNameWithoutExtension = ExtensionUtils.getNameWithoutExtension(xmlName);
        String xmlString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            xmlString = this.local.getPlatformSpringXml(xmlNameWithoutExtension);
            if (StringUtils.isNotBlank((CharSequence)xmlString)) {
                return xmlString;
            }
            if (this.isRemoteConfigOn) {
                xmlString = this.remote.getPlatformSpringXml(xmlNameWithoutExtension);
            }
        } else {
            if (this.isRemoteConfigOn && StringUtils.isNotBlank((CharSequence)(xmlString = this.remote.getPlatformSpringXml(xmlNameWithoutExtension)))) {
                return xmlString;
            }
            xmlString = this.local.getPlatformSpringXml(xmlNameWithoutExtension);
        }
        return xmlString;
    }

    public Properties getProperties(String path, String propertiesName) {
        Properties mergedProperties = new Properties();
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            Properties localProperties;
            if (this.isRemoteConfigOn) {
                Properties remoteProperties;
                Properties groupProperties;
                if (this.isGroupConfigOn && (groupProperties = this.group.getGroupProperties(path, propertiesName)) != null) {
                    mergedProperties.putAll((Map<?, ?>)groupProperties);
                }
                if ((remoteProperties = this.remote.getProperties(path, propertiesName)) != null) {
                    mergedProperties.putAll((Map<?, ?>)remoteProperties);
                }
            }
            if ((localProperties = this.local.getProperties(path, propertiesName)) != null) {
                mergedProperties.putAll((Map<?, ?>)localProperties);
            }
        } else {
            Properties localProperties = this.local.getProperties(path, propertiesName);
            if (localProperties != null) {
                mergedProperties.putAll((Map<?, ?>)localProperties);
            }
            if (this.isRemoteConfigOn) {
                Properties remoteProperties;
                Properties groupProperties;
                if (this.isGroupConfigOn && (groupProperties = this.group.getGroupProperties(path, propertiesName)) != null) {
                    mergedProperties.putAll((Map<?, ?>)groupProperties);
                }
                if ((remoteProperties = this.remote.getProperties(path, propertiesName)) != null) {
                    mergedProperties.putAll((Map<?, ?>)remoteProperties);
                }
            }
        }
        return mergedProperties;
    }

    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        String resourceBundleString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            resourceBundleString = this.local.getString(cl, baseName, locale, key, patternArguments);
            if (resourceBundleString != null) {
                return resourceBundleString;
            }
            if (this.isRemoteConfigOn) {
                resourceBundleString = this.remote.getString(cl, baseName, locale, key, patternArguments);
                if (resourceBundleString != null) {
                    return resourceBundleString;
                }
                if (this.isGroupConfigOn) {
                    resourceBundleString = this.group.getGroupString(cl, baseName, locale, key, patternArguments);
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                resourceBundleString = this.remote.getString(cl, baseName, locale, key, patternArguments);
                if (resourceBundleString != null) {
                    return resourceBundleString;
                }
                if (this.isGroupConfigOn) {
                    resourceBundleString = this.group.getGroupString(cl, baseName, locale, key, patternArguments);
                }
                if (resourceBundleString != null) {
                    return resourceBundleString;
                }
            }
            resourceBundleString = this.local.getString(cl, baseName, locale, key, patternArguments);
        }
        return resourceBundleString;
    }

    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        String moduleString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            moduleString = this.local.getModuleString(moduleName, baseName, key, patternArguments);
            if (moduleString != null) {
                return moduleString;
            }
            if (this.isRemoteConfigOn) {
                moduleString = this.remote.getModuleString(moduleName, baseName, key, patternArguments);
                if (moduleString != null) {
                    return moduleString;
                }
                if (this.isGroupConfigOn) {
                    moduleString = this.group.getGroupModuleString(baseName, key, patternArguments);
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                moduleString = this.remote.getModuleString(moduleName, baseName, key, patternArguments);
                if (moduleString != null) {
                    return moduleString;
                }
                if (this.isGroupConfigOn) {
                    moduleString = this.group.getGroupModuleString(baseName, key, patternArguments);
                }
                if (moduleString != null) {
                    return moduleString;
                }
            }
            moduleString = this.local.getModuleString(moduleName, baseName, key, patternArguments);
        }
        return moduleString;
    }

    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        String applicationString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            applicationString = this.local.getApplicationString(baseName, key, patternArguments);
            if (applicationString != null) {
                return applicationString;
            }
            if (this.isRemoteConfigOn) {
                applicationString = this.remote.getApplicationString(baseName, key, patternArguments);
                if (applicationString != null) {
                    return applicationString;
                }
                if (this.isGroupConfigOn) {
                    applicationString = this.group.getGroupApplicationString(baseName, key, patternArguments);
                }
            }
        } else {
            if (this.isRemoteConfigOn) {
                applicationString = this.remote.getApplicationString(baseName, key, patternArguments);
                if (applicationString != null) {
                    return applicationString;
                }
                if (this.isGroupConfigOn) {
                    applicationString = this.group.getGroupApplicationString(baseName, key, patternArguments);
                }
                if (applicationString != null) {
                    return applicationString;
                }
            }
            applicationString = this.local.getApplicationString(baseName, key, patternArguments);
        }
        return applicationString;
    }

    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        String platformString = null;
        if (ConfigPolicy.LOCAL_FIRST.equals((Object)this.policy)) {
            platformString = this.local.getPlatformString(baseName, key, patternArguments);
            if (platformString != null) {
                return platformString;
            }
            if (this.isRemoteConfigOn) {
                platformString = this.remote.getPlatformString(baseName, key, patternArguments);
            }
        } else {
            if (this.isRemoteConfigOn && (platformString = this.remote.getPlatformString(baseName, key, patternArguments)) != null) {
                return platformString;
            }
            platformString = this.local.getPlatformString(baseName, key, patternArguments);
        }
        return platformString;
    }

    public ConfigPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ConfigPolicy policy) {
        this.policy = policy;
    }

    public boolean isRemoteConfigOn() {
        return this.isRemoteConfigOn;
    }

    public void setRemoteConfigOn(boolean isRemoteConfigOn) {
        this.isRemoteConfigOn = isRemoteConfigOn;
    }

    public boolean isGroupConfigOn() {
        return this.isGroupConfigOn;
    }

    public void setGroupConfigOn(boolean isGroupConfigOn) {
        this.isGroupConfigOn = isGroupConfigOn;
    }

    public void setSetting(ConfigPolicy policy, boolean isRemoteConfigOn, boolean isGroupConfigOn) {
        this.setPolicy(policy);
        this.setRemoteConfigOn(isRemoteConfigOn);
        this.setGroupConfigOn(isGroupConfigOn);
    }
}

