/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModulePropertiesUtils;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.PropertyPlaceholderHelper;

public class DWModuleConfigUtils
extends PropertyPlaceholderConfigurer {
    private static final String MODULE_CONFIG_PROPERTIES = "module";
    private static final PropertyPlaceholderHelper PROPERTY_PLACEHOLDER_HELPER = new PropertyPlaceholderHelper("${", "}", ":", true);

    public int getOrder() {
        return -1000;
    }

    public static String getCurrentModuleProperty(String key) {
        return DWModuleConfigUtils.getCurrentModuleProperty(key, null);
    }

    public static String getCurrentModuleProperty(String key, String defaultValue) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleConfigUtils.getProperty(moduleName, key, defaultValue);
    }

    public static String getProperty(String moduleName, String key) {
        return DWModuleConfigUtils.getProperty(moduleName, key, null);
    }

    public static String getProperty(String moduleName, String key, String defaultValue) {
        String searchValue = DWModulePropertiesUtils.getProperty(MODULE_CONFIG_PROPERTIES, moduleName, key, defaultValue);
        if (searchValue != null) {
            return DWModuleConfigUtils.resolvePlaceholder(searchValue, moduleName);
        }
        return defaultValue;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleConfigUtils.getProperty(moduleName, placeholder);
    }

    public static Properties getProperties(String moduleName) {
        Properties customizationModuleProperties;
        Properties industryModuleProperties;
        Properties result = new Properties();
        Properties applicationModuleProperties = DWPropertiesUtils.getApplicationModuleProperties(MODULE_CONFIG_PROPERTIES, moduleName);
        if (applicationModuleProperties != null) {
            result.putAll((Map<?, ?>)applicationModuleProperties);
        }
        if ((industryModuleProperties = DWPropertiesUtils.getIndustryModuleProperties(MODULE_CONFIG_PROPERTIES, moduleName)) != null) {
            result.putAll((Map<?, ?>)industryModuleProperties);
        }
        if ((customizationModuleProperties = DWPropertiesUtils.getCustomizationModuleProperties(MODULE_CONFIG_PROPERTIES, moduleName)) != null) {
            result.putAll((Map<?, ?>)customizationModuleProperties);
        }
        return result;
    }

    public static String resolvePlaceholder(String placeholderName, final String moduleName) {
        placeholderName = PROPERTY_PLACEHOLDER_HELPER.replacePlaceholders(placeholderName, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                String value = DWModuleConfigUtils.getProperties(moduleName).getProperty(placeholderName);
                return value;
            }
        });
        return placeholderName;
    }
}

