/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.service.TokenBean;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

public class DWLoginResult<TResult>
implements Serializable {
    private LoginPolicy loginPolicy = null;
    private Map<String, Object> profile = null;
    private TResult result = null;
    private TokenBean<TResult> tokenBean = null;

    public DWLoginResult() {
    }

    public DWLoginResult(Map<String, Object> profile, TResult result) {
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        String primerKey = UUID.randomUUID().toString();
        profile.put("primerKey", primerKey);
        this.profile = profile;
        this.result = result;
        TokenBean<TResult> bean = new TokenBean<TResult>(primerKey, profile, result);
        this.tokenBean = bean;
    }

    public DWLoginResult(TokenBean<TResult> tokenBean) {
        this.tokenBean = tokenBean;
        this.profile = tokenBean.getProfile();
        this.result = tokenBean.getResult();
        this.loginPolicy = tokenBean.getLoginPolicy();
        if (this.profile == null) {
            throw new IllegalArgumentException();
        }
        if (this.result == null) {
            throw new IllegalArgumentException();
        }
        if (this.loginPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.profile.put("primerKey", tokenBean.getPrimerKey());
    }

    public LoginPolicy getLoginPolicy() {
        return this.loginPolicy;
    }

    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public TResult getResult() {
        return this.result;
    }

    public TokenBean<TResult> getTokenBean() {
        return this.tokenBean;
    }

    public static enum LoginPolicy {
        ALLOW_MULTIPLE_LOGIN,
        KICK_PRIOR;

    }
}

