/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import org.apache.commons.lang3.StringUtils;

public enum Extension {
    Properties("properties"),
    XML("xml"),
    JSON("json"),
    YML("yml"),
    YAML("yaml"),
    TXT("txt");

    private String value;

    private Extension(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Extension fromString(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("value can not be empty");
        }
        switch (value.toLowerCase()) {
            case "properties": {
                return Properties;
            }
            case "xml": {
                return XML;
            }
            case "json": {
                return JSON;
            }
            case "yml": {
                return YML;
            }
            case "yaml": {
                return YAML;
            }
            case "txt": {
                return TXT;
            }
        }
        throw new IllegalArgumentException(value + " can not map enum");
    }

    public static boolean isValidFormat(String value) {
        try {
            Extension.fromString(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

