/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.remote.listener;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.application.ApplicationConfig;
import com.digiwin.apollo.application.ApplicationConfigFile;
import com.digiwin.apollo.application.ApplicationConfigService;
import com.digiwin.apollo.application.enums.ApplicationPropertyChangeType;
import com.digiwin.apollo.application.model.ApplicationConfigChange;
import com.digiwin.apollo.group.GroupConfig;
import com.digiwin.apollo.group.GroupConfigFile;
import com.digiwin.apollo.group.GroupConfigService;
import com.digiwin.apollo.group.enums.GroupPropertyChangeType;
import com.digiwin.apollo.group.model.GroupConfigChange;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.ExtensionUtils;
import com.digiwin.app.common.config.remote.listener.Change;
import com.digiwin.app.common.config.remote.listener.ChangeType;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeEvent;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeListener;
import com.digiwin.app.common.config.remote.listener.DWPropertiesChangeEvent;
import com.digiwin.app.common.config.remote.listener.DWPropertiesChangeListener;
import java.util.HashMap;
import java.util.Set;

public class ListenerRegister {
    private static final String KEY_APPLICATION = "application";
    private static final String KEY_SHARE = "share.";
    private static final String KEY_LOG4J2 = "log4j2";

    public static void addApplicationPropertiesChangeListener(DWPropertiesChangeListener listener) {
        ApplicationConfig config = ApplicationConfigService.getConfig((String)KEY_APPLICATION);
        ListenerRegister.addPropertiesChangeListener(null, KEY_APPLICATION, config, listener);
    }

    public static void addPropertiesChangeListener(String propertiesNameWithoutExtension, DWPropertiesChangeListener listener) {
        ApplicationConfig config = ApplicationConfigService.getConfig((String)propertiesNameWithoutExtension);
        ListenerRegister.addPropertiesChangeListener(null, propertiesNameWithoutExtension, config, listener);
    }

    public static void addConfigFileChangeListener(String nameWithoutExtension, Extension extension, DWConfigFileChangeListener listener) {
        ApplicationConfigFile configFile = ApplicationConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)ExtensionUtils.toConfigFileFormat(extension));
        ListenerRegister.addConfigFileChangeListener(null, nameWithoutExtension, extension, configFile, listener);
    }

    public static void addGroupApplicationPropertiesChangeListener(DWPropertiesChangeListener listener) {
        GroupConfig config = GroupConfigService.getConfig((String)KEY_APPLICATION);
        ListenerRegister.addGroupPropertiesChangeListener(null, KEY_APPLICATION, config, listener);
    }

    public static void addGroupPropertiesChangeListener(String propertiesNameWithoutExtension, DWPropertiesChangeListener listener) {
        GroupConfig config = GroupConfigService.getConfig((String)propertiesNameWithoutExtension);
        ListenerRegister.addGroupPropertiesChangeListener(null, propertiesNameWithoutExtension, config, listener);
    }

    public static void addGroupConfigFileChangeListener(String nameWithoutExtension, Extension extension, DWConfigFileChangeListener listener) {
        GroupConfigFile configFile = GroupConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)ExtensionUtils.toConfigFileFormat(extension));
        ListenerRegister.addGroupConfigFileChangeListener(null, nameWithoutExtension, extension, configFile, listener);
    }

    public static void addGroupShareModulePropertiesChangeListener(String propertiesNameWithoutExtension, DWPropertiesChangeListener listener) {
        GroupConfig config = GroupConfigService.getConfig((String)(KEY_SHARE + propertiesNameWithoutExtension));
        ListenerRegister.addGroupPropertiesChangeListener(null, propertiesNameWithoutExtension, config, listener);
    }

    public static void addGroupShareModuleConfigFileChangeListener(String nameWithoutExtension, Extension extension, DWConfigFileChangeListener listener) {
        GroupConfigFile configFile = GroupConfigService.getConfigFile((String)(KEY_SHARE + nameWithoutExtension), (ConfigFileFormat)ExtensionUtils.toConfigFileFormat(extension));
        ListenerRegister.addGroupConfigFileChangeListener(null, nameWithoutExtension, extension, configFile, listener);
    }

    public static void addShareModulePropertiesChangeListener(String propertiesNameWithoutExtension, DWPropertiesChangeListener listener) {
        ApplicationConfig config = ApplicationConfigService.getConfig((String)(KEY_SHARE + propertiesNameWithoutExtension));
        ListenerRegister.addPropertiesChangeListener(null, propertiesNameWithoutExtension, config, listener);
    }

    public static void addShareModuleConfigFileChangeListener(String nameWithoutExtension, Extension extension, DWConfigFileChangeListener listener) {
        ApplicationConfigFile configFile = ApplicationConfigService.getConfigFile((String)(KEY_SHARE + nameWithoutExtension), (ConfigFileFormat)ExtensionUtils.toConfigFileFormat(extension));
        ListenerRegister.addConfigFileChangeListener(null, nameWithoutExtension, extension, configFile, listener);
    }

    public static void addModulePropertiesChangeListener(String moduleName, String propertiesNameWithoutExtension, DWPropertiesChangeListener listener) {
        ApplicationConfig config = ApplicationConfigService.getConfig((String)(moduleName + "." + propertiesNameWithoutExtension));
        ListenerRegister.addPropertiesChangeListener(moduleName, propertiesNameWithoutExtension, config, listener);
    }

    public static void addModuleConfigFileChangeListener(String moduleName, String nameWithoutExtension, Extension extension, DWConfigFileChangeListener listener) {
        ApplicationConfigFile configFile = ApplicationConfigService.getConfigFile((String)(moduleName + "." + nameWithoutExtension), (ConfigFileFormat)ExtensionUtils.toConfigFileFormat(extension));
        ListenerRegister.addConfigFileChangeListener(moduleName, nameWithoutExtension, extension, configFile, listener);
    }

    public static void addLog4j2XmlChangeListener(DWConfigFileChangeListener listener) {
        ApplicationConfigFile configFile = ApplicationConfigService.getConfigFile((String)KEY_LOG4J2, (ConfigFileFormat)ConfigFileFormat.XML);
        ListenerRegister.addConfigFileChangeListener(null, KEY_LOG4J2, Extension.XML, configFile, listener);
    }

    public static void addGroupLog4j2XmlChangeListener(DWConfigFileChangeListener listener) {
        GroupConfigFile configFile = GroupConfigService.getConfigFile((String)KEY_LOG4J2, (ConfigFileFormat)ConfigFileFormat.XML);
        ListenerRegister.addGroupConfigFileChangeListener(null, KEY_LOG4J2, Extension.XML, configFile, listener);
    }

    private static void addPropertiesChangeListener(String moduleName, String propertiesNameWithoutExtension, ApplicationConfig config, DWPropertiesChangeListener listener) {
        config.addChangeListener(changeEvent -> {
            HashMap<String, Change> changes = new HashMap<String, Change>();
            Set changedKeys = changeEvent.changedKeys();
            for (String key : changedKeys) {
                ApplicationConfigChange configChange = changeEvent.getChange(key);
                ApplicationPropertyChangeType changeType = configChange.getChangeType();
                String oldValue = configChange.getOldValue();
                String newValue = configChange.getNewValue();
                switch (changeType) {
                    case ADDED: {
                        Change createChange = new Change(oldValue, newValue, ChangeType.CREATE);
                        changes.put(key, createChange);
                        break;
                    }
                    case DELETED: {
                        Change deleteChange = new Change(oldValue, newValue, ChangeType.DELETE);
                        changes.put(key, deleteChange);
                        break;
                    }
                    case MODIFIED: {
                        Change updateChange = new Change(oldValue, newValue, ChangeType.UPDATE);
                        changes.put(key, updateChange);
                    }
                }
            }
            DWPropertiesChangeEvent propertiesChangeEvent = new DWPropertiesChangeEvent(moduleName, propertiesNameWithoutExtension, changes);
            listener.onChange(propertiesChangeEvent);
        });
    }

    private static void addConfigFileChangeListener(String moduleName, String nameWithoutExtension, Extension extension, ApplicationConfigFile configFile, DWConfigFileChangeListener listener) {
        configFile.addChangeListener(changeEvent -> {
            ApplicationPropertyChangeType changeType = changeEvent.getChangeType();
            String oldValue = changeEvent.getOldValue();
            String newValue = changeEvent.getNewValue();
            switch (changeType) {
                case ADDED: {
                    DWConfigFileChangeEvent configFileChangeEventCreate = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.CREATE);
                    listener.onChange(configFileChangeEventCreate);
                    break;
                }
                case DELETED: {
                    DWConfigFileChangeEvent configFileChangeEventDelete = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.DELETE);
                    listener.onChange(configFileChangeEventDelete);
                    break;
                }
                case MODIFIED: {
                    DWConfigFileChangeEvent configFileChangeEventUpdate = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.UPDATE);
                    listener.onChange(configFileChangeEventUpdate);
                }
            }
        });
    }

    private static void addGroupPropertiesChangeListener(String moduleName, String propertiesNameWithoutExtension, GroupConfig config, DWPropertiesChangeListener listener) {
        config.addChangeListener(changeEvent -> {
            HashMap<String, Change> changes = new HashMap<String, Change>();
            Set changedKeys = changeEvent.changedKeys();
            for (String key : changedKeys) {
                GroupConfigChange configChange = changeEvent.getChange(key);
                GroupPropertyChangeType changeType = configChange.getChangeType();
                String oldValue = configChange.getOldValue();
                String newValue = configChange.getNewValue();
                switch (changeType) {
                    case ADDED: {
                        Change createChange = new Change(oldValue, newValue, ChangeType.CREATE);
                        changes.put(key, createChange);
                        break;
                    }
                    case DELETED: {
                        Change deleteChange = new Change(oldValue, newValue, ChangeType.DELETE);
                        changes.put(key, deleteChange);
                        break;
                    }
                    case MODIFIED: {
                        Change updateChange = new Change(oldValue, newValue, ChangeType.UPDATE);
                        changes.put(key, updateChange);
                    }
                }
            }
            DWPropertiesChangeEvent propertiesChangeEvent = new DWPropertiesChangeEvent(moduleName, propertiesNameWithoutExtension, changes);
            listener.onChange(propertiesChangeEvent);
        });
    }

    private static void addGroupConfigFileChangeListener(String moduleName, String nameWithoutExtension, Extension extension, GroupConfigFile configFile, DWConfigFileChangeListener listener) {
        configFile.addChangeListener(changeEvent -> {
            GroupPropertyChangeType changeType = changeEvent.getChangeType();
            String oldValue = changeEvent.getOldValue();
            String newValue = changeEvent.getNewValue();
            switch (changeType) {
                case ADDED: {
                    DWConfigFileChangeEvent configFileChangeEventCreate = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.CREATE);
                    listener.onChange(configFileChangeEventCreate);
                    break;
                }
                case DELETED: {
                    DWConfigFileChangeEvent configFileChangeEventDelete = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.DELETE);
                    listener.onChange(configFileChangeEventDelete);
                    break;
                }
                case MODIFIED: {
                    DWConfigFileChangeEvent configFileChangeEventUpdate = new DWConfigFileChangeEvent(moduleName, nameWithoutExtension, extension, oldValue, newValue, ChangeType.UPDATE);
                    listener.onChange(configFileChangeEventUpdate);
                }
            }
        });
    }
}

