/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.service.DWFilterUtils;
import com.digiwin.app.service.DWMiddleLayerRequest;
import com.digiwin.app.service.DWMiddleLayerResponse;
import com.digiwin.app.service.DWRequest;
import com.digiwin.app.service.DWResponse;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public abstract class DWFilter
extends DWFilterUtils
implements Filter {
    private static Log log = LogFactory.getLog(DWFilter.class);

    protected abstract DWMiddleLayerRequest onRequest(DWRequest var1) throws Exception;

    protected abstract DWMiddleLayerResponse onResponse(DWResponse var1) throws Exception;

    protected abstract DWMiddleLayerResponse onException(DWResponse var1, Throwable var2) throws Exception;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            DWFilterUtils.ContentCachingRequest contentCachingRequest = new DWFilterUtils.ContentCachingRequest(this, request);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            DWFilterUtils.ContentCachingResponse contentCachingResponse = new DWFilterUtils.ContentCachingResponse(this, response);
            DWRequest DWRequest2 = this.generateDWRequest(contentCachingRequest);
            DWMiddleLayerRequest middleLayerRequest = this.onRequest(DWRequest2);
            this.invoke(middleLayerRequest, contentCachingRequest, contentCachingResponse);
            DWResponse DWResponse2 = this.generateDWResponse(contentCachingResponse, response);
            int originalStatus = response.getStatus();
            DWMiddleLayerResponse middleLayerResponse = this.generateDWMiddleLayerResponse(DWResponse2, originalStatus);
            String charset = middleLayerResponse.getCharset();
            String contentType = middleLayerResponse.getContentType();
            Map<String, String> externalHeaderMap = middleLayerResponse.getExternalHeaderMap();
            int status = middleLayerResponse.getStatus();
            String result = middleLayerResponse.getResult();
            servletResponse.setCharacterEncoding(charset);
            PrintWriter printWriter = servletResponse.getWriter();
            contentCachingResponse.setContentType(contentType);
            if (status == 0) {
                contentCachingResponse.setStatus(originalStatus);
            } else {
                contentCachingResponse.setStatus(status);
            }
            Set<String> keys = externalHeaderMap.keySet();
            for (String key : keys) {
                contentCachingResponse.setHeader(key, externalHeaderMap.get(key));
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            charArrayWriter.write(result);
            servletResponse.setContentLength(charArrayWriter.toString().getBytes().length);
            printWriter.write(charArrayWriter.toString());
            printWriter.close();
        }
        catch (Exception e) {
            log.warn((Object)"DWFilter doFilter failed!", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private void invoke(DWMiddleLayerRequest middleLayerRequest, DWFilterUtils.ContentCachingRequest request, DWFilterUtils.ContentCachingResponse response) throws Exception {
        String moduleName = middleLayerRequest.getModuleName();
        String serviceName = middleLayerRequest.getServiceName();
        String methodName = middleLayerRequest.getMethodName();
        String parameter = middleLayerRequest.getParameter();
        Map<String, Object> profile = middleLayerRequest.getProfile();
        StringBuilder profileJsonStringBuilder = new StringBuilder();
        Set<String> keys = profile.keySet();
        for (String key : keys) {
            profileJsonStringBuilder.append(",");
            profileJsonStringBuilder.append("\"" + key + "\"");
            profileJsonStringBuilder.append(":");
            profileJsonStringBuilder.append("\"" + profile.get(key) + "\"");
        }
        String profileJsonString = profileJsonStringBuilder.toString();
        if (profileJsonString.length() != 0) {
            profileJsonString = profileJsonString.replaceFirst(",", "");
        }
        profileJsonString = "{" + profileJsonString + "}";
        request.addParameter("parameter", new String[]{parameter});
        request.addParameter("profileJsonString", new String[]{profileJsonString});
        StringBuilder urlStringBuilder = new StringBuilder();
        urlStringBuilder.append("/restful");
        urlStringBuilder.append("/middlelayer");
        urlStringBuilder.append("/" + moduleName);
        urlStringBuilder.append("/" + serviceName);
        urlStringBuilder.append("/" + methodName);
        request.getRequestDispatcher(urlStringBuilder.toString()).forward((ServletRequest)request, (ServletResponse)response);
    }

    private DWRequest generateDWRequest(DWFilterUtils.ContentCachingRequest contentCachingRequest) throws Exception {
        HashMap<String, Object> requestHeaderMap = new HashMap<String, Object>();
        String requestBody = "";
        String requestUrl = "";
        Enumeration headerNames = contentCachingRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            requestHeaderMap.put(headerName, contentCachingRequest.getHeader(headerName));
        }
        StringWriter stringWriter = new StringWriter();
        this.copyInputStream((InputStream)contentCachingRequest.getInputStream(), stringWriter, "UTF-8");
        requestBody = stringWriter.toString();
        requestUrl = contentCachingRequest.getRequestURI();
        return new DWRequest(requestHeaderMap, requestBody, requestUrl);
    }

    private DWResponse generateDWResponse(DWFilterUtils.ContentCachingResponse contentCachingResponse, HttpServletResponse response) throws Exception {
        ServletOutputStream executeResult = contentCachingResponse.getOutputStream();
        int originalStatus = response.getStatus();
        return new DWResponse((OutputStream)executeResult, originalStatus);
    }

    private DWMiddleLayerResponse generateDWMiddleLayerResponse(DWResponse DWResponse2, int originalStatus) throws Exception {
        DWMiddleLayerResponse middleLayerResponse = null;
        if (200 <= originalStatus && originalStatus < 300) {
            middleLayerResponse = this.onResponse(DWResponse2);
        } else {
            Map<?, ?> jsonMap = this.parseJson(DWResponse2.getExecuteResultAsString());
            Boolean isDWException = Boolean.valueOf((String)jsonMap.get("isDWException"));
            if (isDWException.booleanValue()) {
                String errorMessage = (String)jsonMap.get("errorMessage");
                String stackTraceString = (String)jsonMap.get("stackTraceString");
                StringBuilder DWExceptionMessage = new StringBuilder();
                DWExceptionMessage.append("\u932f\u8aa4\u4fe1\u606f: ").append(errorMessage);
                DWExceptionMessage.append(System.lineSeparator());
                DWExceptionMessage.append("\u932f\u8aa4\u5806\u758a: ").append(stackTraceString);
                middleLayerResponse = new DWMiddleLayerResponse("text/csv", DWExceptionMessage.toString());
            } else {
                String exceptionByteArrayString = (String)jsonMap.get("exceptionByteArrayString");
                exceptionByteArrayString = exceptionByteArrayString.substring(1, exceptionByteArrayString.length() - 1);
                String[] exceptionByteArrayStringArray = exceptionByteArrayString.split(",");
                byte[] exceptionByteArray = new byte[exceptionByteArrayStringArray.length];
                for (int i = 0; i < exceptionByteArray.length; ++i) {
                    exceptionByteArray[i] = Byte.parseByte(exceptionByteArrayStringArray[i].trim());
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(exceptionByteArray);
                ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
                Object exception = objectInput.readObject();
                objectInput.close();
                middleLayerResponse = this.onException(DWResponse2, (Throwable)exception);
            }
        }
        return middleLayerResponse;
    }
}

