/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.client.InvokeCrossCloudDapService;
import com.digiwin.app.persistconn.client.InvokeDapService;
import com.digiwin.app.persistconn.client.InvokeOtherDapService;
import com.digiwin.app.persistconn.client.InvokeSaasService;
import com.digiwin.app.persistconn.client.InvokeTenantDapService;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import com.digiwin.app.serviceclient.rpc.DWInvMessage;
import com.digiwin.app.serviceclient.rpc.DWInvTarget;
import com.digiwin.app.serviceclient.rpc.DWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvoker;
import com.digiwin.app.serviceclient.rpc.protocol.DWInvokerFactory;
import com.digiwin.app.serviceclient.rpc.util.DWInvocationBuilder;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ServiceClient {
    private String digiHostAcct;
    private Map<String, String> customHeader = new HashMap<String, String>();
    private Map<String, String> customCallbackHeader = new HashMap<String, String>();

    public String invokeSaasService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeSaasService client = new InvokeSaasService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeThisDapService(String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(moduleName, serviceName, methodName, parameter);
        InvokeThisDapService client = new InvokeThisDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeOtherDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeOtherDapService client = new InvokeOtherDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeDapService client = new InvokeDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeTenantDapService client = new InvokeTenantDapService(gatewayId, pojo, timeout, timeoutUnit);
        String result = client.invoke();
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        return this.invokeTenantDapService(gatewayId, apName, moduleName, serviceName, methodName, parameter, -1, TimeUnit.SECONDS);
    }

    public String invokeTenantEaiService(String site_id, String prod, String name, String uid, Map<String, Object> parameter) throws Exception {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).sync();
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = dwEAI.execute();
        return new Gson().toJson((Object)result);
    }

    public String invokeTenantEaiServiceAsync(String site_id, String prod, String name, String uid, Map<String, Object> parameter, String callbackId) throws Exception {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).async(callbackId);
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = dwEAI.execute();
        return new Gson().toJson((Object)result);
    }

    public String invokeCrossCloudDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeCrossCloudDapService client = new InvokeCrossCloudDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public void setDigiHostAcct(String digiHostAcct) {
        this.digiHostAcct = digiHostAcct;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }

    public <R> R invoke(IDWInvocation invocation, Class<R> entityTypeOfR) throws DWInvocationException, IOException {
        return this.invoke(invocation, (Type)entityTypeOfR);
    }

    public <R> R invoke(IDWInvocation invocation, Type entityTypeOfR) throws DWInvocationException, IOException {
        Objects.requireNonNull(invocation);
        IDWInvoker invoker = DWInvokerFactory.create(invocation);
        Object result = invoker.invoke(invocation, entityTypeOfR);
        return result;
    }

    public <R> R invoke(DWInvTarget target, DWInvMessage message, Class<R> entityTypeOfR) throws DWInvocationException, IOException {
        return this.invoke(target, message, (Type)entityTypeOfR);
    }

    public <R> R invoke(DWInvTarget target, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException, IOException {
        DWInvocation invocation = new DWInvocation(target, message);
        return this.invoke((IDWInvocation)invocation, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, DWInvMessage message, Class<R> entityTypeOfR) throws DWInvocationException, IOException {
        return this.invoke(apName, servicePath, null, (Type)entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException, IOException {
        return this.invoke(apName, servicePath, null, message, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, String action, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException, IOException {
        IDWInvocation invocation = DWInvocationBuilder.create(apName, servicePath, action, message);
        return this.invoke(invocation, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, Class<R> entityTypeOfR) throws DWInvocationException, IOException {
        return this.invoke(apName, servicePath, (DWInvMessage)null, entityTypeOfR);
    }
}

