/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.protocol.http;

import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.serviceclient.rpc.IDWInvMessage;
import com.digiwin.app.serviceclient.rpc.IDWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvoker;
import com.digiwin.app.serviceclient.rpc.protocol.http.DWHttpRequestConverter;
import com.digiwin.http.client.DWHttpClient;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class DWHttpInvoker
implements IDWInvoker {
    @Override
    public <R> R invoke(IDWInvocation invocation, Class<R> resultType) throws DWInvocationException, IOException {
        return this.invoke(invocation, (Type)resultType);
    }

    @Override
    public <R> R invoke(IDWInvocation invocation, Type entityTypeOfR) throws DWInvocationException, IOException {
        Object entity;
        DWHttpClient client = new DWHttpClient();
        HttpUriRequest request = DWHttpRequestConverter.convert(invocation);
        IDWInvMessage message = invocation.getMessage();
        Map<String, String> headers = message.getHeaders();
        headers.entrySet().stream().forEach(item -> request.addHeader((String)item.getKey(), (String)item.getValue()));
        if (request instanceof HttpEntityEnclosingRequest && (entity = invocation.getMessage().getEntity()) != null) {
            Gson gson = DWGsonProvider.getGson();
            String json = gson.toJson(entity);
            StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)stringEntity);
        }
        return (R)client.execute(request, entityTypeOfR);
    }
}

