/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.protocol.http;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.serviceclient.exception.DWLocalInvocationException;
import com.digiwin.app.serviceclient.rpc.DWDapInvTarget;
import com.digiwin.app.serviceclient.rpc.IDWInvMessage;
import com.digiwin.app.serviceclient.rpc.IDWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvoker;
import com.digiwin.app.serviceclient.rpc.protocol.IDWInvTarget;
import com.digiwin.app.serviceclient.rpc.protocol.http.DWHttpRequestConverter;
import com.digiwin.http.client.DWHttpClient;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class DWHttpInvoker
implements IDWInvoker {
    @Override
    public <R> R invoke(IDWInvocation invocation, Class<R> resultType) throws DWInvocationException, IOException {
        return this.invoke(invocation, (Type)resultType);
    }

    private <R> R covert(Object result, Type entityTypeOfR) throws DWLocalInvocationException {
        Gson gson = DWGsonProvider.getGson();
        String jsonString = gson.toJson(result);
        if (entityTypeOfR == String.class) {
            return (R)jsonString;
        }
        Object newTypeInstance = gson.fromJson(jsonString, entityTypeOfR);
        return (R)newTypeInstance;
    }

    @Override
    public <R> R invoke(IDWInvocation invocation, Type entityTypeOfR) throws DWInvocationException, IOException {
        Object entity;
        if (this.isSameApp(invocation.getTarget())) {
            Object entity2;
            Map mapEntity;
            Object localService = null;
            DWMethod localMethod = null;
            DWDefaultParameters parameters = null;
            DWDapInvTarget thisDapInvTarget = (DWDapInvTarget)invocation.getTarget();
            DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
            String moduleName = thisDapInvTarget.getModuleName();
            String interfaceName = thisDapInvTarget.getInterfaceName();
            String methodName = thisDapInvTarget.getMethodName();
            DWHeader header = containerContext.getDWHeader(moduleName, interfaceName);
            if (header != null && (localMethod = containerContext.getDWMethod(header, methodName, (DWParameters)(parameters = new DWDefaultParameters(mapEntity = (entity2 = invocation.getMessage().getEntity()) instanceof Map ? (Map)entity2 : null)))) != null) {
                try {
                    localService = containerContext.getService(header, localMethod);
                }
                catch (Exception e) {
                    throw new DWLocalInvocationException("get local service failed!", e);
                }
            }
            if (localService != null) {
                Map profile = DWServiceContext.getContext().getProfile();
                try {
                    Object result = containerContext.invoke(moduleName, interfaceName, methodName, parameters, profile);
                    if (result == null || entityTypeOfR instanceof Class && ((Class)entityTypeOfR).isInstance(result)) {
                        return (R)result;
                    }
                    return this.covert(result, entityTypeOfR);
                }
                catch (Exception e) {
                    throw new DWLocalInvocationException("invoke local service failed!", e);
                }
            }
        }
        DWHttpClient client = new DWHttpClient();
        HttpUriRequest request = DWHttpRequestConverter.convert(invocation);
        IDWInvMessage message = invocation.getMessage();
        Map<String, String> headers = message.getHeaders();
        headers.entrySet().stream().forEach(item -> request.addHeader((String)item.getKey(), (String)item.getValue()));
        if (request instanceof HttpEntityEnclosingRequest && (entity = invocation.getMessage().getEntity()) != null) {
            Gson gson = DWGsonProvider.getGson();
            String json = gson.toJson(entity);
            StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)stringEntity);
        }
        return (R)client.execute(request, entityTypeOfR);
    }

    private boolean isSameApp(IDWInvTarget invocationTarget) {
        if (invocationTarget instanceof DWDapInvTarget) {
            DWDapInvTarget dapInvTarget = (DWDapInvTarget)invocationTarget;
            String targetAppId = dapInvTarget.getAppId();
            String currentAppId = DWApplicationConfigUtils.getProperty((String)"appId");
            return currentAppId == null ? false : currentAppId.equalsIgnoreCase(targetAppId);
        }
        return false;
    }
}

