/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.eai.DigiProtocol;
import com.digiwin.app.eai.DigiService;
import com.digiwin.app.eai.DigiType;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.RouteCondition;
import com.digiwin.app.persistconn.client.InvokeDapService;
import com.digiwin.app.persistconn.client.InvokeOtherDapService;
import com.digiwin.app.persistconn.client.InvokeSaasService;
import com.digiwin.app.persistconn.client.InvokeTenantDapService;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.serviceclient.exception.AuthorizationException;
import com.digiwin.app.serviceclient.exception.DWCrossTenantAuthorizationNotFoundException;
import com.digiwin.app.serviceclient.exception.DWTenantDataShareCenterException;
import com.digiwin.app.serviceclient.exception.OperationException;
import com.digiwin.app.serviceclient.rpc.DWInvMessage;
import com.digiwin.app.serviceclient.rpc.DWInvTarget;
import com.digiwin.app.serviceclient.rpc.DWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvoker;
import com.digiwin.app.serviceclient.rpc.protocol.DWInvokerFactory;
import com.digiwin.app.serviceclient.rpc.util.DWInvocationBuilder;
import com.digiwin.app.serviceclient.util.ServiceClientUtil;
import com.digiwin.iam.IAMIdentityService;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceClient {
    private static Log log = LogFactory.getLog(ServiceClient.class);
    @Deprecated
    private String digiHostAcct;
    private Map<String, String> customHeader = new HashMap<String, String>();
    private Map<String, String> customCallbackHeader = new HashMap<String, String>();
    private RouteCondition routeCondition = new RouteCondition();

    public String invokeSaasService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        pojo.setRouteCondition(this.routeCondition);
        InvokeSaasService client = new InvokeSaasService(pojo);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public String invokeThisDapService(String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        DWResourcePojo pojo = new DWResourcePojo(moduleName, serviceName, methodName, parameter);
        InvokeThisDapService client = new InvokeThisDapService(pojo);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public String invokeOtherDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeOtherDapService client = new InvokeOtherDapService(pojo);
        pojo.setRouteCondition(this.routeCondition);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public String invokeDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeDapService client = new InvokeDapService(pojo);
        pojo.setRouteCondition(this.routeCondition);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeTenantDapService client = new InvokeTenantDapService(gatewayId, pojo, timeout, timeoutUnit);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        return this.invokeTenantDapService(gatewayId, apName, moduleName, serviceName, methodName, parameter, -1, TimeUnit.SECONDS);
    }

    public String invokeTenantEaiService(String site_id, String prod, String name, String uid, Map<String, Object> parameter) {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).sync();
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = new HashMap();
        try {
            result = dwEAI.execute();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return new Gson().toJson(result);
    }

    public String invokeTenantEaiServiceAsync(String site_id, String prod, String name, String uid, Map<String, Object> parameter, String callbackId) {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).async(callbackId);
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = new HashMap();
        try {
            result = dwEAI.execute();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return new Gson().toJson(result);
    }

    public String invokeTenantEaiServiceFasync(String site_id, String prod, String name, String uid, Map<String, Object> parameter, String callbackId) {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).fasync(callbackId);
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = new HashMap();
        try {
            result = dwEAI.execute();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return new Gson().toJson(result);
    }

    public String invokeTenantEaiServiceOnCustom(DigiType digiType, DigiProtocol digiProtocol, DigiHost digiHost, DigiService digiService, Map<String, Object> parameter, String digiDatakey, String callback) {
        DWEAI dwEAI = new DWEAI(digiType, digiProtocol, digiHost, digiService, parameter);
        dwEAI.setDigiDatakey(digiDatakey);
        dwEAI.setCallback(callback);
        dwEAI.setCustomHeader(this.customHeader);
        dwEAI.setCustomCallbackHeader(this.customCallbackHeader);
        Map result = new HashMap();
        try {
            result = dwEAI.execute();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return new Gson().toJson(result);
    }

    public List<Map<String, Object>> invokeCrossTenantService(String partnerTenantid, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> tdscParameter = new HashMap<String, Object>();
        tdscParameter.put("partnerTenantid", partnerTenantid);
        tdscParameter.put("dataProviderAppId", apName);
        tdscParameter.put("dataProviderResourceName", "restful/service/" + moduleName + "/" + serviceName + "/" + methodName);
        String tdscResult = this.invokeOtherDapService("tdsc", "tdsc", "IAuthorizationService", "getIsAuthorized", tdscParameter);
        Map tdscResultMap = (Map)DWGsonProvider.getGson().fromJson(tdscResult, Map.class);
        if (tdscResultMap.containsKey("errorType")) {
            throw new DWTenantDataShareCenterException(tdscResult);
        }
        Map tdscResultResponseMap = (Map)tdscResultMap.get("response");
        Map tdscResultResponseDataMap = (Map)tdscResultResponseMap.get("data");
        List tdscDataIsAuthorizedDatas = (List)tdscResultResponseDataMap.get("tdsc_data_is_authorized");
        if (tdscDataIsAuthorizedDatas == null || tdscDataIsAuthorizedDatas.size() == 0) {
            throw new AuthorizationException((Throwable)((Object)new DWCrossTenantAuthorizationNotFoundException()));
        }
        String token = DWServiceContext.getContext().getToken();
        for (Map tdscDataIsAuthorizedData : tdscDataIsAuthorizedDatas) {
            String userId = String.valueOf(tdscDataIsAuthorizedData.get("user_id"));
            String userPasswordHash = String.valueOf(tdscDataIsAuthorizedData.get("user_password_hash"));
            IAMIdentityService iamIdentityService = new IAMIdentityService();
            String newToken = null;
            try {
                newToken = iamIdentityService.login(userId, userPasswordHash);
            }
            catch (Exception e) {
                ServiceClientUtil.logStackTrace(log, e);
                throw new OperationException(e);
            }
            DWServiceContext.getContext().setToken(newToken);
            String otherServiceResult = this.invokeOtherDapService(apName, moduleName, serviceName, methodName, parameter);
            Map otherServiceResultMap = (Map)DWGsonProvider.getGson().fromJson(otherServiceResult, Map.class);
            result.add(otherServiceResultMap);
        }
        DWServiceContext.getContext().setToken(token);
        return result;
    }

    @Deprecated
    public void setDigiHostAcct(String digiHostAcct) {
        this.digiHostAcct = digiHostAcct;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }

    public <R> R invoke(IDWInvocation invocation, Class<R> entityTypeOfR) throws DWInvocationException {
        return this.invoke(invocation, (Type)entityTypeOfR);
    }

    public <R> R invoke(IDWInvocation invocation, Type entityTypeOfR) throws DWInvocationException {
        Objects.requireNonNull(invocation);
        IDWInvoker invoker = DWInvokerFactory.create(invocation);
        R result = null;
        try {
            result = invoker.invoke(invocation, entityTypeOfR);
        }
        catch (IOException e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return result;
    }

    public <R> R invoke(DWInvTarget target, DWInvMessage message, Class<R> entityTypeOfR) throws DWInvocationException {
        return this.invoke(target, message, (Type)entityTypeOfR);
    }

    public <R> R invoke(DWInvTarget target, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException {
        DWInvocation invocation = new DWInvocation(target, message);
        return this.invoke((IDWInvocation)invocation, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, DWInvMessage message, Class<R> entityTypeOfR) throws DWInvocationException {
        return this.invoke(apName, servicePath, null, (Type)entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException {
        return this.invoke(apName, servicePath, null, message, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, String action, DWInvMessage message, Type entityTypeOfR) throws DWInvocationException {
        IDWInvocation invocation = null;
        try {
            invocation = DWInvocationBuilder.create(apName, servicePath, action, message);
        }
        catch (IOException e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        return this.invoke(invocation, entityTypeOfR);
    }

    public <R> R invoke(String apName, String servicePath, Class<R> entityTypeOfR) throws DWInvocationException {
        return this.invoke(apName, servicePath, (DWInvMessage)null, entityTypeOfR);
    }

    public RouteCondition getRouteCondition() {
        return this.routeCondition;
    }

    public void setRouteCondition(RouteCondition routeCondition) {
        this.routeCondition = routeCondition;
    }
}

