/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer.simplified;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.autoconfigurer.simplified.condition.DWSimplifiedModeCondition;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWServiceBuilder;
import com.digiwin.app.service.DWServiceDefinitionParser;
import com.digiwin.app.service.simplified.DWGroupServiceLookupProcessor;
import com.digiwin.app.service.simplified.spring.DWSimplifiedSpringServiceBuilder;
import com.digiwin.app.service.simplified.utils.DWGroupScanHelper;
import com.digiwin.app.service.simplified.utils.DWSimplifiedGroupResourceManager;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
@Conditional(value={DWSimplifiedModeCondition.class})
public class DWSimplifiedServiceLookupAutoConfiguration {
    @Bean(value={"dw-service-builder"})
    public DWServiceBuilder getServiceBuilder() {
        DWSimplifiedSpringServiceBuilder builder = new DWSimplifiedSpringServiceBuilder();
        DWServiceInfo.setServiceBuilder((DWServiceBuilder)builder);
        return builder;
    }

    @Bean(value={"dw-group-resource-manager"})
    public DWSimplifiedGroupResourceManager getGroupResourceManager() {
        return new DWSimplifiedGroupResourceManager();
    }

    @Bean(value={"dw-service-lookup-processor"})
    public DWGroupServiceLookupProcessor getServiceLookupProcessor(List<DWServiceDefinitionParser> serviceDefParsers, DWSimplifiedGroupResourceManager groupResourceManager) {
        DWGroupServiceLookupProcessor processor = new DWGroupServiceLookupProcessor(serviceDefParsers, (DWGroupScanHelper.DWGroupScanListener)groupResourceManager);
        return processor;
    }
}

