/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer.simplified;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWServiceBuilder;
import com.digiwin.app.service.DWServiceDefinitionParser;
import com.digiwin.app.service.DWServiceGroupInfoProvider;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.simplified.DWGroupServiceLookupProcessor;
import com.digiwin.app.service.simplified.spring.DWSimplifiedSpringServiceBuilder;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.DWSimplifiedServiceGroupInfoProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
@ConditionalOnClass(name={"com.digiwin.simplified.boot.SimplifiedBoot"}, value={DWGroupServiceLookupProcessor.class})
public class DWSimplifiedServiceLookupAutoConfiguration {
    @Bean(value={"dw-service-builder"})
    public DWServiceBuilder getServiceBuilder() {
        DWSimplifiedSpringServiceBuilder builder = new DWSimplifiedSpringServiceBuilder();
        DWServiceInfo.setServiceBuilder((DWServiceBuilder)builder);
        return builder;
    }

    @Bean(value={"dw-group-resource-manager"})
    public DWSimplifiedResourceManager getGroupResourceManager(Environment environment) {
        String excludeGroupString = environment.getProperty("dap.group.exclude");
        List excludeGroupList = excludeGroupString == null ? Collections.emptyList() : Arrays.asList(excludeGroupString.split(","));
        return new DWSimplifiedResourceManager(excludeGroupList);
    }

    @Bean(value={"dw-service-lookup-processor"})
    public DWGroupServiceLookupProcessor getServiceLookupProcessor(List<DWServiceDefinitionParser> serviceDefParsers, DWSimplifiedResourceManager groupResourceManager, @Nullable DWServiceCommonsProvider serviceCommonsProvider) {
        DWGroupServiceLookupProcessor processor = new DWGroupServiceLookupProcessor(serviceDefParsers, groupResourceManager);
        if (serviceCommonsProvider != null) {
            processor.setCommonsInterfaces(serviceCommonsProvider.getInterfaceServices());
            processor.setCommonsImplements(serviceCommonsProvider.getImplementServices());
        }
        return processor;
    }

    @ConditionalOnMissingBean(value={DWServiceGroupInfoProvider.class})
    @Bean(value={"dw-service-group-info-provider"})
    public DWServiceGroupInfoProvider getServiceGroupInfoProvider() {
        DWSimplifiedServiceGroupInfoProvider provider = new DWSimplifiedServiceGroupInfoProvider();
        return provider;
    }
}

