/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.asm.ClassReader;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.ClassNameReader;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.DefaultGeneratorStrategy;
import org.springframework.cglib.core.DefaultNamingPolicy;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.internal.Function;
import org.springframework.cglib.core.internal.LoadingCache;

public abstract class AbstractClassGenerator<T>
implements ClassGenerator {
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private static volatile Map<ClassLoader, ClassLoaderData> CACHE = new WeakHashMap<ClassLoader, ClassLoaderData>();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;
    private String className;
    private boolean attemptLoad;

    protected T wrapCachedClass(Class klass) {
        return (T)new WeakReference<Class>(klass);
    }

    protected Object unwrapCachedValue(T cached) {
        return ((WeakReference)cached).get();
    }

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected final String getClassName() {
        return this.className;
    }

    private void setClassName(String className) {
        this.className = className;
    }

    private String generateClassName(Predicate nameTestPredicate) {
        return this.namingPolicy.getClassName(this.namePrefix, this.source.name, this.key, nameTestPredicate);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        if (namingPolicy == null) {
            namingPolicy = DefaultNamingPolicy.INSTANCE;
        }
        this.namingPolicy = namingPolicy;
    }

    public NamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setAttemptLoad(boolean attemptLoad) {
        this.attemptLoad = attemptLoad;
    }

    public boolean getAttemptLoad() {
        return this.attemptLoad;
    }

    public void setStrategy(GeneratorStrategy strategy) {
        if (strategy == null) {
            strategy = DefaultGeneratorStrategy.INSTANCE;
        }
        this.strategy = strategy;
    }

    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    public static AbstractClassGenerator getCurrent() {
        return (AbstractClassGenerator)CURRENT.get();
    }

    public ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            t = this.getClass().getClassLoader();
        }
        if (t == null) {
            t = Thread.currentThread().getContextClassLoader();
        }
        if (t == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object create(Object key) {
        try {
            Object object;
            ClassLoader loader = this.getClassLoader();
            Map<ClassLoader, ClassLoaderData> cache = CACHE;
            ClassLoaderData data = cache.get(loader);
            if (data == null) {
                Class<AbstractClassGenerator> var5 = AbstractClassGenerator.class;
                Class<AbstractClassGenerator> clazz = AbstractClassGenerator.class;
                // MONITORENTER : org.springframework.cglib.core.AbstractClassGenerator.class
                cache = CACHE;
                data = cache.get(loader);
                if (data == null) {
                    WeakHashMap<ClassLoader, ClassLoaderData> newCache = new WeakHashMap<ClassLoader, ClassLoaderData>(cache);
                    data = new ClassLoaderData(loader);
                    newCache.put(loader, data);
                    CACHE = newCache;
                }
                // MONITOREXIT : clazz
            }
            this.key = key;
            Object obj = data.get(this, this.getUseCache());
            if (obj instanceof Class) {
                object = this.firstInstance((Class)obj);
                return object;
            }
            object = this.nextInstance(obj);
            return object;
        }
        catch (RuntimeException var9) {
            throw var9;
        }
        catch (Error var10) {
            throw var10;
        }
        catch (Exception var11) {
            throw new CodeGenerationException((Throwable)var11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Class generate(ClassLoaderData data) {
        save = AbstractClassGenerator.CURRENT.get();
        AbstractClassGenerator.CURRENT.set(this);
        try {
            classLoader = data.getClassLoader();
            if (classLoader == null) {
                throw new IllegalStateException("ClassLoader is null while trying to define class " + this.getClassName() + ". It seems that the loader has been expired from a weak reference somehow. Please file an issue at cglib's issue tracker.");
            }
            var6_7 = classLoader;
            synchronized (var6_7) {
                className = this.generateClassName(data.getUniqueNamePredicate());
                data.reserveName(className);
                this.setClassName(className);
            }
            if (!this.attemptLoad) ** GOTO lbl-1000
            try {
                var8_13 = var25 = (gen = classLoader.loadClass(this.getClassName()));
                return var8_13;
            }
            catch (ClassNotFoundException var25) {
                try lbl-1000:
                // 2 sources

                {
                    b = this.strategy.generate((ClassGenerator)this);
                    className = ClassNameReader.getClassName((ClassReader)new ClassReader(b));
                    protectionDomain = this.getProtectionDomain();
                    if (!this.getProtectionDomain().getClassLoader().equals(classLoader) && this.getProtectionDomain().getClassLoader().equals(classLoader.getParent())) {
                        classLoader = classLoader.getParent();
                    }
                    var9_15 = classLoader;
                    synchronized (var9_15) {
                        gen = protectionDomain == null ? ReflectUtils.defineClass((String)className, (byte[])b, (ClassLoader)classLoader) : ReflectUtils.defineClass((String)className, (byte[])b, (ClassLoader)classLoader, (ProtectionDomain)protectionDomain);
                    }
                    var8 = gen;
                }
                catch (RuntimeException var21) {
                    throw var21;
                }
                catch (Error var22) {
                    throw var22;
                }
                catch (Exception var23) {
                    throw new CodeGenerationException((Throwable)var23);
                }
                catch (Throwable var11_18) {
                    throw var11_18;
                }
            }
        }
        finally {
            AbstractClassGenerator.CURRENT.set(save);
        }
        return var8;
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class ClassLoaderData {
        private final Set<String> reservedClassNames = new HashSet<String>();
        private final LoadingCache<AbstractClassGenerator, Object, Object> generatedClasses;
        private final WeakReference<ClassLoader> classLoader;
        private final Predicate uniqueNamePredicate = new Predicate(){

            public boolean evaluate(Object name) {
                return reservedClassNames.contains(name);
            }
        };
        private static final Function<AbstractClassGenerator, Object> GET_KEY = new Function<AbstractClassGenerator, Object>(){

            public Object apply(AbstractClassGenerator gen) {
                return gen.key;
            }
        };

        public ClassLoaderData(ClassLoader classLoader) {
            if (classLoader == null) {
                throw new IllegalArgumentException("classLoader == null is not yet supported");
            }
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            Function<AbstractClassGenerator, Object> load = new Function<AbstractClassGenerator, Object>(){

                public Object apply(AbstractClassGenerator gen) {
                    Class klass = gen.generate(this);
                    return gen.wrapCachedClass(klass);
                }
            };
            this.generatedClasses = new LoadingCache(GET_KEY, (Function)load);
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoader.get();
        }

        public void reserveName(String name) {
            this.reservedClassNames.add(name);
        }

        public Predicate getUniqueNamePredicate() {
            return this.uniqueNamePredicate;
        }

        public Object get(AbstractClassGenerator gen, boolean useCache) {
            if (!useCache) {
                return gen.generate(this);
            }
            Object cachedValue = this.generatedClasses.get((Object)gen);
            return gen.unwrapCachedValue(cachedValue);
        }
    }

    protected static class Source {
        String name;

        public Source(String name) {
            this.name = name;
        }
    }
}

