/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified.spring;

import com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.simplified.DWLocalFirstClassLoader;
import com.digiwin.app.service.simplified.utils.DWGroupScanHelper;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class DWOrderedExtLayerSourceSpringApplication
extends SpringApplication {
    public DWOrderedExtLayerSourceSpringApplication(Class<?> ... primarySources) {
        super((Class[])primarySources);
    }

    public DWOrderedExtLayerSourceSpringApplication(ResourceLoader resourceLoader, Class<?> ... primarySources) {
        super(resourceLoader, (Class[])primarySources);
    }

    public ConfigurableApplicationContext run(String ... args) {
        this.buildOrderlyExtensionLayerSourceLoadingEnvironment();
        System.setProperty("dap.mybatis.configuration.result-map.allow-add-duplicate-id", "true");
        return super.run(args);
    }

    private void buildOrderlyExtensionLayerSourceLoadingEnvironment() {
        try {
            System.out.println("building orderly extension layer source loading environment...");
            ClassLoader customizationClassLoader = this.createOrderlyExtensionLayerSourceClassLoader();
            DWGroupScanHelper.setUserDefinedClassLoader((ClassLoader)customizationClassLoader);
            DWModuleClassLoader.setUserDefinedClassLoader((ClassLoader)customizationClassLoader);
            System.out.println("set current context class loader to: " + customizationClassLoader);
            Thread.currentThread().setContextClassLoader(customizationClassLoader);
            System.out.println("Orderly extension layer source loading environment prepared!");
        }
        catch (Exception e) {
            throw new RuntimeException("Create orderly extension layer source loading environment failed!", e);
        }
    }

    private ClassLoader createOrderlyExtensionLayerSourceClassLoader() throws Exception {
        this.printDapInfoLocations();
        this.initBusinessExtensionLayers();
        DWGroupExtensionLayerSourceScanHelper groupScanHelper = new DWGroupExtensionLayerSourceScanHelper();
        List urlList = (List)groupScanHelper.scan();
        ClassLoader parent = this.getSystemOrLauncherClassLoader();
        URL[] urlsToArray = new URL[urlList.size()];
        urlList.toArray(urlsToArray);
        DWLocalFirstClassLoader classLoader = new DWLocalFirstClassLoader(urlsToArray, parent);
        return classLoader;
    }

    private ClassLoader getSystemOrLauncherClassLoader() {
        ClassLoader prevClassLoader;
        ClassLoader currentThreadClassLoader = ClassLoader.getSystemClassLoader();
        do {
            prevClassLoader = currentThreadClassLoader;
        } while ((currentThreadClassLoader = currentThreadClassLoader.getParent()).getParent() != null);
        return prevClassLoader;
    }

    private void initBusinessExtensionLayers() {
        String extensionLayersString = DWSimplifiedApolloApplicationListener.getExtensionLayersString();
        DWSimplifiedResourceUtils.initBusinessExtensionLayers((String)extensionLayersString);
    }

    private void printDapInfoLocations() throws IOException {
        int seq = 0;
        Enumeration<URL> urls = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/dap.info");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            System.out.println(seq + "." + url);
        }
    }

    private static class DWCollectExtensionLayerResourceManager
    extends DWSimplifiedResourceManager {
        private Map<String, Map<Integer, List<DWSimplifiedGroupLocationInfo>>> locationInfoMap = new HashMap<String, Map<Integer, List<DWSimplifiedGroupLocationInfo>>>();
        private List<URL> orderlyExtensionLayerSourceList = new ArrayList<URL>();

        public DWCollectExtensionLayerResourceManager() {
            super(null);
        }

        public void registerGroup(DWSimplifiedGroupLocationInfo groupInfo) {
            Map groupLocationInfoMap = this.locationInfoMap.computeIfAbsent(groupInfo.getName(), key -> new HashMap());
            List list = groupLocationInfoMap.computeIfAbsent(groupInfo.getBusinessLayer(), key -> new ArrayList());
            list.add(groupInfo);
        }

        public synchronized void completeInitialization() {
            this.orderlyExtensionLayerSourceList.clear();
            for (Map<Integer, List<DWSimplifiedGroupLocationInfo>> layerMap : this.locationInfoMap.values()) {
                List subUrlList = layerMap.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.reverseOrder())).flatMap(entry -> ((List)entry.getValue()).stream()).map(locationInfo -> locationInfo.getData()).collect(Collectors.toList());
                this.orderlyExtensionLayerSourceList.addAll(subUrlList);
            }
        }
    }

    private static class DWGroupExtensionLayerSourceScanHelper
    extends DWGroupScanHelper<List<URL>> {
        private static DWCollectExtensionLayerResourceManager resourceManager = new DWCollectExtensionLayerResourceManager();

        public DWGroupExtensionLayerSourceScanHelper() {
            super((DWSimplifiedResourceManager)resourceManager, null);
        }

        protected List<URL> createScanContext() {
            return resourceManager.orderlyExtensionLayerSourceList;
        }

        protected void onJarScan(DWSimplifiedGroupLocationInfo groupInfo, JarFile jarFile, List<URL> scanContext) {
        }

        protected void onClassPathScan(DWSimplifiedGroupLocationInfo groupInfo, File classPath, List<URL> scanContext) {
        }

        protected void onClassScan(String groupName, String jarName, Class<?> clazz, List<URL> scanContext) {
        }
    }
}

