/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified;

import com.digiwin.app.common.DWXClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;

public class DWLocalFirstClassLoader
extends DWXClassLoader {
    public DWLocalFirstClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = super.getResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> urlList = new LinkedHashSet<URL>();
        urlList.addAll(Collections.list(this.findResources(name)));
        if (this.getParent() != null) {
            urlList.addAll(Collections.list(this.getParent().getResources(name)));
        }
        return Collections.enumeration(urlList);
    }

    public URL findResource(String name) {
        return super.findResource(name);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\n");
        return sb.toString();
    }
}

