/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.resource.DWApplicationResourceBundleUtils;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedI18nPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;

public class DWSimplifiedApplicationMessageSource
implements MessageSource {
    private ResourceBundleMessageSource extraMessageSource = null;

    public DWSimplifiedApplicationMessageSource() {
        this(new String[]{null});
    }

    public DWSimplifiedApplicationMessageSource(String ... extraBaseNames) {
        String[] validNames;
        if (extraBaseNames != null && (validNames = (String[])Arrays.stream(extraBaseNames).filter(name -> name != null && !"message".equals(name)).toArray(String[]::new)).length > 0) {
            this.extraMessageSource = new ResourceBundleMessageSource();
            this.extraMessageSource.setBasenames(validNames);
        }
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message = this.getStringWithDefaultMessage(false, code, null, args);
        if (message == null && this.extraMessageSource != null) {
            message = this.extraMessageSource.getMessage(code, args, null, LocaleContextHolder.getLocale());
        }
        if (message == null) {
            message = defaultMessage != null ? defaultMessage : DWResourceBundleUtils.getNotFoundString((String)DWSimplifiedI18nPropertiesUtils.getApplicationDefaultBaseName((int)DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD), (String)code);
        }
        return message;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, args, null, null);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new NotImplementedException("unknown purpose, operator not support yet!");
    }

    private String getStringWithDefaultMessage(boolean generateNotFoundMessage, String code, String defaultMessage, Object[] args) {
        String result = null;
        result = ConfigPool.getInstance().getApplicationString("message", code, args);
        if (result == null) {
            result = DWApplicationResourceBundleUtils.getPlatformString((String)"message", (String)code, (Object[])args);
        }
        if (result == null) {
            if (defaultMessage != null) {
                result = defaultMessage;
            } else if (generateNotFoundMessage) {
                String applicationMessageBaseName = DWSimplifiedI18nPropertiesUtils.getApplicationDefaultBaseName((int)DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD);
                result = DWResourceBundleUtils.getNotFoundString((String)applicationMessageBaseName, (String)code);
            }
        }
        return result;
    }
}

