/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedConfigPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertySource;

public class DWGroupConfigUtilsPropertySource
extends PropertySource<Properties> {
    public static final String DAP_GROUP_PROPERTY_SOURCE = "dap-group-propertysource";
    private static Log log = LogFactory.getLog(DWGroupConfigUtilsPropertySource.class);
    private boolean init = false;

    private DWGroupConfigUtilsPropertySource(String name) {
        super(name, (Object)new Properties());
    }

    public static DWGroupConfigUtilsPropertySource createInstance() {
        return DWGroupConfigUtilsPropertySource.createInstance(DAP_GROUP_PROPERTY_SOURCE);
    }

    public static DWGroupConfigUtilsPropertySource createInstance(String propertySourceName) {
        return new DWGroupConfigUtilsPropertySource(propertySourceName);
    }

    private Properties getProperties() {
        if (!this.init) {
            Properties allGroupProperties = (Properties)this.source;
            List groupNameList = DWSimplifiedResourceManager.getGroupNameList();
            for (String groupName : groupNameList) {
                Properties standardProperties = DWSimplifiedConfigPropertiesUtils.getGroupProperties((String)groupName, (int)DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD);
                if (standardProperties != null) {
                    allGroupProperties.putAll((Map<?, ?>)standardProperties);
                }
                for (int i = 0; i <= DWSimplifiedResourceUtils.getBusinessExtensionMaxLayerIndex(); ++i) {
                    Properties extensionProperties = DWSimplifiedConfigPropertiesUtils.getGroupProperties((String)groupName, (int)i);
                    allGroupProperties.putAll((Map<?, ?>)extensionProperties);
                }
            }
            this.init = true;
        }
        return (Properties)this.source;
    }

    public Object getProperty(String name) {
        if (!DWSimplifiedResourceManager.isInitializationCompleted((String)name)) {
            return null;
        }
        return this.getProperties().getProperty(name);
    }

    public boolean containsProperty(String name) {
        if (!DWSimplifiedResourceManager.isInitializationCompleted((String)name)) {
            return false;
        }
        return this.getProperties().containsKey(name);
    }
}

