/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.resource.simplified.spring.DWApplicationConfigUtilsPropertySource;
import com.digiwin.resource.simplified.spring.DWGroupConfigUtilsPropertySource;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class DWPropertySourceAppContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
EnvironmentPostProcessor,
Ordered {
    public int getOrder() {
        return -2147483639;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        Object dapPropertySource;
        Log log = LogFactory.getLog(DWPropertySourceAppContextInitializer.class);
        log.info((Object)"***DAP Simplified Mode DWPropertySourceAppContextInitializer.....");
        Object currentGroupPropertySource = applicationContext.getEnvironment().getPropertySources().remove("dap-group-propertysource");
        if (currentGroupPropertySource == null) {
            currentGroupPropertySource = DWGroupConfigUtilsPropertySource.createInstance();
        }
        if ((dapPropertySource = applicationContext.getEnvironment().getPropertySources().remove("dap-application-propertysource")) == null) {
            dapPropertySource = DWApplicationConfigUtilsPropertySource.createInstance();
        }
        DWPropertySourceAppContextInitializer.reOrderPropertySources(applicationContext);
        applicationContext.getEnvironment().getPropertySources().addFirst(currentGroupPropertySource);
        applicationContext.getEnvironment().getPropertySources().addAfter(currentGroupPropertySource.getName(), dapPropertySource);
        applicationContext.getBeanFactory().registerSingleton(dapPropertySource.getName(), dapPropertySource);
        log.info((Object)String.format("***DAP Simplified Mode init business extension layers=%s ...", DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList()));
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        DWGroupConfigUtilsPropertySource currentGroupPropertySource = DWGroupConfigUtilsPropertySource.createInstance();
        DWApplicationConfigUtilsPropertySource appPropertySource = DWApplicationConfigUtilsPropertySource.createInstance();
        environment.getPropertySources().addFirst((PropertySource)currentGroupPropertySource);
        environment.getPropertySources().addAfter(currentGroupPropertySource.getName(), (PropertySource)appPropertySource);
    }

    public static void reOrderPropertySources(ConfigurableApplicationContext applicationContext) {
        String springbootConfigPropertiesName;
        ArrayList<Object> dapPropertySourceSequence = new ArrayList<Object>();
        MutablePropertySources rootPropertySources = applicationContext.getEnvironment().getPropertySources();
        if (rootPropertySources.contains("dap-group-propertysource")) {
            dapPropertySourceSequence.add(rootPropertySources.get("dap-group-propertysource"));
        }
        if (rootPropertySources.contains("dap-application-propertysource")) {
            dapPropertySourceSequence.add(rootPropertySources.get("dap-application-propertysource"));
        }
        if (rootPropertySources.contains(springbootConfigPropertiesName = "configurationProperties")) {
            dapPropertySourceSequence.add(rootPropertySources.get(springbootConfigPropertiesName));
        }
        for (PropertySource ps : rootPropertySources) {
            if (!(ps instanceof OriginTrackedMapPropertySource)) continue;
            dapPropertySourceSequence.add((OriginTrackedMapPropertySource)ps);
        }
        if (rootPropertySources.contains("systemProperties")) {
            dapPropertySourceSequence.add(rootPropertySources.get("systemProperties"));
        }
        if (rootPropertySources.contains("systemEnvironment")) {
            dapPropertySourceSequence.add(rootPropertySources.get("systemEnvironment"));
        }
        for (int i = dapPropertySourceSequence.size() - 1; i >= 0; --i) {
            rootPropertySources.remove(((PropertySource)dapPropertySourceSequence.get(i)).getName());
            rootPropertySources.addFirst((PropertySource)dapPropertySourceSequence.get(i));
        }
    }
}

