/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified.utils;

import com.digiwin.resource.simplified.DWSimplifiedGroupInfoComparator;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.URLClassPath;

public abstract class DWGroupScanHelper<T> {
    private Log log = LogFactory.getLog(DWGroupScanHelper.class);
    private DWSimplifiedResourceManager resourceManager;
    private ClassLoader classLoader;

    protected abstract T createScanContext();

    public DWGroupScanHelper() {
        this(null, ClassLoader.getSystemClassLoader());
    }

    public DWGroupScanHelper(DWSimplifiedResourceManager resourceManager, ClassLoader scanSource) {
        this.classLoader = scanSource == null ? ClassLoader.getSystemClassLoader() : scanSource;
        this.resourceManager = resourceManager;
    }

    protected void onGroupJarScan(String groupName, List<DWSimplifiedJarFileGroupInfo> jarInfoList, T scanContext) {
        for (DWSimplifiedJarFileGroupInfo jarFileGroupInfo : jarInfoList) {
            JarFile jarFile = jarFileGroupInfo.getJarFile();
            try {
                if (this.resourceManager != null) {
                    this.resourceManager.registerGroup(jarFileGroupInfo.getGroupInfo());
                }
                this.onJarScan(jarFileGroupInfo.getGroupInfo(), jarFile, scanContext);
            }
            catch (Exception e) {
                this.onJarScanFiled(groupName, jarFile, e);
            }
        }
    }

    protected void onJarScan(DWSimplifiedGroupLocationInfo groupInfo, JarFile jarFile, T scanContext) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
            String className = jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6);
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                this.onClassScan(groupInfo.getName(), jarFile.getName(), clazz, scanContext);
            }
            catch (Throwable e) {
                this.onClassScanFailed(groupInfo.getName(), jarFile, className, e);
            }
        }
        try {
            jarFile.close();
        }
        catch (Exception e) {
            this.log.error((Object)("file=" + jarFile.getName() + " can't close properly!"), (Throwable)e);
        }
    }

    private List<String> searchAllClassesFile(File classesPath) {
        File[] subFiles;
        ArrayList<String> classesFileNameList = new ArrayList<String>();
        for (File subFile : subFiles = classesPath.listFiles()) {
            if (subFile.isDirectory()) {
                classesFileNameList.addAll(this.searchAllClassesFile(subFile));
                continue;
            }
            String fileName = subFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            classesFileNameList.add(subFile.getAbsolutePath());
        }
        return classesFileNameList;
    }

    protected void onClassPathScan(DWSimplifiedGroupLocationInfo groupInfo, File classPath, T scanContext) {
        List<String> classesFileList = this.searchAllClassesFile(classPath);
        for (String classesFileName : classesFileList) {
            classesFileName = classesFileName.substring(classPath.getAbsolutePath().length() + 1);
            String className = classesFileName.replace(File.separatorChar, '.').substring(0, classesFileName.length() - 6);
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                this.onClassScan(groupInfo.getName(), classesFileName, clazz, scanContext);
            }
            catch (Throwable e) {
                this.onClassScanFailed(groupInfo.getName(), classPath, className, e);
            }
        }
    }

    protected void onGroupClassPathScan(String groupName, List<DWSimplifiedClassPathGroupInfo> groupInfoList, T scanContext) {
        for (DWSimplifiedClassPathGroupInfo classPathGroupInfo : groupInfoList) {
            File classPath = classPathGroupInfo.getClassPath();
            try {
                if (this.resourceManager != null) {
                    this.resourceManager.registerGroup(classPathGroupInfo.getGroupInfo());
                }
                this.onClassPathScan(classPathGroupInfo.getGroupInfo(), classPath, scanContext);
            }
            catch (Exception e) {
                this.onClassPathScanFiled(groupName, classPath, e);
            }
        }
    }

    private void innerScan(T scanContext) {
        GroupNameHelper groupNameHelper = new GroupNameHelper();
        try {
            if (this.classLoader instanceof URLClassLoader) {
                Field ucpField = this.classLoader.getClass().getDeclaredField("ucp");
                ucpField.setAccessible(true);
                URLClassPath ucp = (URLClassPath)ucpField.get(this.classLoader);
                ucpField.setAccessible(false);
                Field loadersField = URLClassPath.class.getDeclaredField("loaders");
                loadersField.setAccessible(true);
                List loaders = (List)loadersField.get(ucp);
                loadersField.setAccessible(false);
                loaders.forEach(l -> groupNameHelper.match(l));
                DWSimplifiedGroupInfoComparator comparator = new DWSimplifiedGroupInfoComparator();
                groupNameHelper.groupUrlList.forEach((groupName, urlList) -> {
                    urlList.sort(comparator);
                    ArrayList<DWSimplifiedClassPathGroupInfo> classPathGroupInfoList = new ArrayList<DWSimplifiedClassPathGroupInfo>();
                    ArrayList<DWSimplifiedJarFileGroupInfo> jarFileGroupInfoList = new ArrayList<DWSimplifiedJarFileGroupInfo>();
                    for (DWSimplifiedGroupLocationInfo groupInfo : urlList) {
                        try {
                            if (groupInfo.isClassPath()) {
                                classPathGroupInfoList.add(new DWSimplifiedClassPathGroupInfo(groupInfo));
                                continue;
                            }
                            jarFileGroupInfoList.add(new DWSimplifiedJarFileGroupInfo(groupInfo));
                        }
                        catch (IOException | URISyntaxException e) {
                            this.log.warn((Object)String.format("DWGroupScanHelper create JarFile(%s) failed!", groupInfo.getData()), (Throwable)e);
                        }
                    }
                    this.onGroupJarScan((String)groupName, (List<DWSimplifiedJarFileGroupInfo>)jarFileGroupInfoList, scanContext);
                    this.onGroupClassPathScan((String)groupName, (List<DWSimplifiedClassPathGroupInfo>)classPathGroupInfoList, scanContext);
                });
                groupNameHelper.close();
            } else {
                this.log.error((Object)"System ClassLoader is not instance of URLClassLoader, DWGroupServiceLookupProcessor scanByLoaders failed!");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.log.error((Object)"DWGroupServiceLookupProcessor scanByLoaders failed!", (Throwable)e);
        }
    }

    protected abstract void onClassScan(String var1, String var2, Class<?> var3, T var4);

    protected void onJarScanFiled(String groupName, JarFile file, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(groupName).append("]");
        message.append(" jar=").append(file.getName()).append(" scan failed!");
        this.log.error((Object)message.toString(), (Throwable)e);
    }

    protected void onClassPathScanFiled(String groupName, File classPath, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(groupName).append("]");
        message.append(" jar=").append(classPath.getAbsolutePath()).append(" scan failed!");
        this.log.error((Object)message.toString(), (Throwable)e);
    }

    protected void onClassScanFailed(String groupName, JarFile file, String className, Throwable e) {
        this.onClassScanFailed(groupName, file.getName(), className, e);
    }

    protected void onClassScanFailed(String groupName, File filePath, String className, Throwable e) {
        this.onClassScanFailed(groupName, filePath.getAbsolutePath(), className, e);
    }

    private void onClassScanFailed(String groupName, String source, String className, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(groupName).append("]");
        message.append(" source=").append(source);
        message.append(" class=").append(className).append(" scan failed!");
        this.log.error((Object)message, e);
    }

    public T scan() {
        T scanContext = this.createScanContext();
        this.innerScan(scanContext);
        if (this.resourceManager != null) {
            this.resourceManager.completeInitialization();
        }
        return scanContext;
    }

    public static class DWSimplifiedJarFileGroupInfo
    extends DWSimplifiedGroupInfoProvider {
        private JarFile jarFile;

        protected DWSimplifiedJarFileGroupInfo(DWSimplifiedGroupLocationInfo groupInfo) throws IOException, URISyntaxException {
            super(groupInfo);
            this.createJarFile();
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }

        public void close() throws IOException {
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
        }

        public JarFile createJarFile() throws IOException, URISyntaxException {
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
            this.jarFile = DWSimplifiedGroupLocationInfo.createJarFile((DWSimplifiedGroupLocationInfo)this.getGroupInfo());
            return this.jarFile;
        }
    }

    public static class DWSimplifiedClassPathGroupInfo
    extends DWSimplifiedGroupInfoProvider {
        private File classPath;

        protected DWSimplifiedClassPathGroupInfo(DWSimplifiedGroupLocationInfo groupInfo) throws URISyntaxException {
            super(groupInfo);
            this.classPath = DWSimplifiedGroupLocationInfo.createClassPath((DWSimplifiedGroupLocationInfo)groupInfo);
        }

        public File getClassPath() {
            return this.classPath;
        }
    }

    public static abstract class DWSimplifiedGroupInfoProvider {
        private DWSimplifiedGroupLocationInfo groupInfo;

        protected DWSimplifiedGroupInfoProvider(DWSimplifiedGroupLocationInfo groupInfo) {
            this.groupInfo = groupInfo;
        }

        public DWSimplifiedGroupLocationInfo getGroupInfo() {
            return this.groupInfo;
        }
    }

    private class GroupNameHelper {
        private Field csuField;
        private Field dirField;
        private Map<String, List<DWSimplifiedGroupLocationInfo>> groupUrlList = new LinkedHashMap<String, List<DWSimplifiedGroupLocationInfo>>();

        private GroupNameHelper() {
        }

        public void match(Object loader) {
            URL url = null;
            DWSimplifiedGroupLocationInfo groupInfo = null;
            try {
                if (loader.getClass().getName().endsWith("$JarLoader")) {
                    if (this.csuField == null) {
                        Class<?> jarLoaderClazz = loader.getClass();
                        this.csuField = jarLoaderClazz.getDeclaredField("csu");
                        this.csuField.setAccessible(true);
                    }
                    if ((url = (URL)this.csuField.get(loader)) == null) {
                        DWGroupScanHelper.this.log.warn((Object)("Parse loaded jar group name failed, url is empty!" + loader));
                    } else {
                        groupInfo = DWSimplifiedResourceUtils.getGroupName((URI)url.toURI());
                    }
                } else if (loader.getClass().getName().endsWith("$FileLoader")) {
                    File dir;
                    if (this.dirField == null) {
                        Class<?> fileLoaderClazz = loader.getClass();
                        this.dirField = fileLoaderClazz.getDeclaredField("dir");
                        this.dirField.setAccessible(true);
                    }
                    if ((dir = (File)this.dirField.get(loader)) != null && (groupInfo = DWSimplifiedResourceUtils.getGroupName((File)dir)) != null) {
                        url = dir.toURI().toURL();
                    }
                }
            }
            catch (Exception e) {
                DWGroupScanHelper.this.log.warn((Object)("Parse loaded jar group name failed, loader = " + loader), (Throwable)e);
            }
            if (groupInfo != null) {
                if (DWSimplifiedResourceManager.isGroupExcluded((String)groupInfo.getName())) {
                    DWGroupScanHelper.this.log.warn((Object)String.format("Group [%s] has been excluded!", groupInfo.getName()));
                } else {
                    groupInfo.setData(url);
                    List urlList = this.groupUrlList.computeIfAbsent(groupInfo.getName(), k -> new ArrayList());
                    urlList.add(groupInfo);
                }
            }
        }

        public void close() {
            if (this.csuField != null) {
                this.csuField.setAccessible(false);
                this.csuField = null;
            }
            if (this.dirField != null) {
                this.dirField.setAccessible(false);
                this.dirField = null;
            }
            if (this.groupUrlList != null) {
                this.groupUrlList.clear();
            }
        }
    }
}

