/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified.utils;

import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.simplified.utils.DWGroupScanHelper;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWGroupServiceImplementationScanHelper
extends DWGroupScanHelper<Map<String, List<DWServiceInfo>>> {
    private Log log = LogFactory.getLog(DWGroupScanHelper.class);

    public DWGroupServiceImplementationScanHelper(DWSimplifiedResourceManager resourceManager) {
        this(resourceManager, null);
    }

    public DWGroupServiceImplementationScanHelper(DWSimplifiedResourceManager resourceManager, ClassLoader classLoader) {
        super(resourceManager, classLoader);
    }

    @Override
    protected Map<String, List<DWServiceInfo>> createScanContext() {
        return new HashMap<String, List<DWServiceInfo>>();
    }

    @Override
    protected void onGroupJarScan(String groupName, List<DWGroupScanHelper.DWSimplifiedJarFileGroupInfo> jarInfoList, Map<String, List<DWServiceInfo>> scanContext) {
        if (jarInfoList.size() > 0) {
            this.log.info((Object)String.format("+ <%s> Jar File Locations:", groupName));
        }
        super.onGroupJarScan(groupName, jarInfoList, scanContext);
    }

    @Override
    protected void onGroupClassPathScan(String groupName, List<DWGroupScanHelper.DWSimplifiedClassPathGroupInfo> groupInfoList, Map<String, List<DWServiceInfo>> scanContext) {
        if (groupInfoList.size() > 0) {
            this.log.info((Object)String.format("+ <%s> Class Path Locations:", groupName));
        }
        super.onGroupClassPathScan(groupName, groupInfoList, scanContext);
    }

    @Override
    protected void onJarScan(DWSimplifiedGroupLocationInfo groupInfo, JarFile jarFile, Map<String, List<DWServiceInfo>> scanContext) {
        this.log.info((Object)String.format("  |___ %s", groupInfo.toString(this::getLayerName)));
        super.onJarScan(groupInfo, jarFile, scanContext);
    }

    @Override
    protected void onClassPathScan(DWSimplifiedGroupLocationInfo groupInfo, File classPath, Map<String, List<DWServiceInfo>> scanContext) {
        this.log.info((Object)String.format("  |___ %s", groupInfo.toString(this::getLayerName)));
        super.onClassPathScan(groupInfo, classPath, scanContext);
    }

    private String getLayerName(int layerIndex) {
        List extNameList = DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList();
        String layerName = layerIndex <= DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD ? "[Standard]" : (layerIndex > extNameList.size() ? "!Invalid Index, please contact DAP for this issue!" : (String)extNameList.get(layerIndex));
        return layerName;
    }

    @Override
    protected void onClassScan(String groupName, String jarName, Class<?> clazz, Map<String, List<DWServiceInfo>> scanContext) {
        Class<?>[] interfaces;
        if (clazz.isInterface()) {
            return;
        }
        for (Class<?> serviceInterface : interfaces = clazz.getInterfaces()) {
            if (!this.isDWServiceImplementation(serviceInterface)) continue;
            this.addServiceInfo(groupName, serviceInterface, clazz, scanContext);
        }
    }

    private boolean isDWServiceImplementation(Class<?> interfaceClazz) {
        Class<?>[] interfaces;
        for (Class<?> serviceInterface : interfaces = interfaceClazz.getInterfaces()) {
            if (serviceInterface != DWService.class) continue;
            return true;
        }
        return false;
    }

    private void addServiceInfo(String groupName, Class<?> serviceInterface, Class<?> serviceImplement, Map<String, List<DWServiceInfo>> scanContext) {
        List serviceList = scanContext.computeIfAbsent(groupName, k -> new ArrayList());
        DWServiceInfo oldVerServiceInfo = null;
        for (DWServiceInfo serviceInfo : serviceList) {
            if (!serviceInfo.getInterfaceType().getName().equals(serviceInterface.getName())) continue;
            oldVerServiceInfo = serviceInfo;
            break;
        }
        if (oldVerServiceInfo != null) {
            serviceList.remove(oldVerServiceInfo);
        }
        serviceList.add(new DWServiceInfo(groupName, serviceInterface, serviceImplement));
    }
}

