/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified.spring;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceBuilder;
import org.springframework.context.ApplicationContext;

public class DWSimplifiedSpringServiceBuilder
implements DWServiceBuilder {
    public Object build(Object service, String groupName) throws Exception {
        if (service == null) {
            return null;
        }
        ApplicationContext context = SpringContextUtils.getContext();
        if (context != null) {
            String beanId = this.getBeanId(service);
            if (context.containsBean(beanId)) {
                return context.getBean(beanId);
            }
            service = this.createInstance(service);
            context.getAutowireCapableBeanFactory().autowireBean(service);
            Object springBean = context.getAutowireCapableBeanFactory().applyBeanPostProcessorsAfterInitialization(service, beanId);
            return springBean;
        }
        service = this.createInstance(service);
        return service;
    }

    private Object createInstance(Object service) throws Exception {
        if (service instanceof Class) {
            return ((Class)service).newInstance();
        }
        return service;
    }

    private String getBeanId(Object service) {
        if (service instanceof Class) {
            return ((Class)service).getSimpleName();
        }
        return service.getClass().getSimpleName();
    }
}

