/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.simplified;

import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWAbstractServiceProcessor;
import com.digiwin.app.service.DWServiceDefinitionParser;
import com.digiwin.app.service.simplified.utils.DWGroupServiceImplementationScanHelper;
import com.digiwin.app.service.simplified.utils.DWGroupServiceInterfaceScanHelper;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWGroupServiceLookupProcessor
extends DWAbstractServiceProcessor {
    private static Log log = LogFactory.getLog(DWGroupServiceLookupProcessor.class);
    private Map<String, List<Class<?>>> commonsInterfaces;
    private Map<String, List<DWServiceInfo>> commonsImplements;
    private DWSimplifiedResourceManager resourceManager;

    public DWGroupServiceLookupProcessor(List<DWServiceDefinitionParser> parsers, DWSimplifiedResourceManager resourceManager) {
        super(parsers);
        this.resourceManager = resourceManager;
    }

    public void process() {
        log.info((Object)"DWGroupServiceLookupProcessor start to search DWService...");
        DWGroupServiceInterfaceScanHelper interfaceScanHelper = new DWGroupServiceInterfaceScanHelper();
        Map interfaces = (Map)interfaceScanHelper.scan();
        if (this.commonsInterfaces != null && this.commonsInterfaces.size() > 0) {
            interfaces.putAll(this.commonsInterfaces);
        }
        int totalCount = 0;
        for (Map.Entry item : interfaces.entrySet()) {
            this.log((String)item.getKey(), (List)item.getValue(), totalCount);
            totalCount += ((List)item.getValue()).size();
        }
        DWGroupServiceImplementationScanHelper implementationScanHelper = new DWGroupServiceImplementationScanHelper(this.resourceManager);
        Map implementations = (Map)implementationScanHelper.scan();
        if (this.commonsImplements != null && this.commonsImplements.size() > 0) {
            implementations.putAll(this.commonsImplements);
        }
        for (DWServiceDefinitionParser parser : this.parsers) {
            parser.parseInterface(interfaces);
            parser.parseImplementation(implementations);
        }
    }

    public void process(String groupName) {
    }

    private void log(String groupName, List<Class<?>> interfaceList, Integer startIndex) {
        StringBuilder message = new StringBuilder();
        int i = startIndex == null ? 0 : startIndex;
        for (Class<?> interfaceClass : interfaceList) {
            message.setLength(0);
            message.append(">>> Found Header ").append(++i).append(".");
            message.append("group=").append(groupName);
            message.append(", service name=").append(interfaceClass.getSimpleName());
            message.append(", type=").append(interfaceClass.getName());
            log.info((Object)message.toString());
        }
    }

    public Map<String, List<Class<?>>> getCommonsInterfaces() {
        return this.commonsInterfaces;
    }

    public void setCommonsInterfaces(Map<String, List<Class<?>>> commonsInterfaces) {
        this.commonsInterfaces = commonsInterfaces;
    }

    public Map<String, List<DWServiceInfo>> getCommonsImplements() {
        return this.commonsImplements;
    }

    public void setCommonsImplements(Map<String, List<DWServiceInfo>> commonsImplements) {
        this.commonsImplements = commonsImplements;
    }
}

