/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.module.DWModuleConfigUtils;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.spring.DWSimplifiedSpringResource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DWSimplifiedSpringXMLResourceReader
extends XmlBeanDefinitionReader {
    private static Log log = LogFactory.getLog(DWSimplifiedSpringXMLResourceReader.class);
    public static final String DW_PLATFORM_PROPERTIES_URL = "dw:platform:properties";
    public static final String DW_APPLICATION_PROPERTIES_URL = "dw:application:properties";
    public static final String DW_RESOURCE_URL_PREFIX = "dw:resource:";
    public static final String DW_GROUP_DEFAULT_SPRING_XML_URL = "dw:groups:default-spring-xml";
    public static final String CONFIG_KEY_PLATFORM_SPRING_XML_FILE_NAMES = "platformSpringConfigFileNames";
    public static final String CONFIG_KEY_APPLICATION_OR_GROUP_SPRING_XML_FILE_NAMES = "springConfigFileNames";
    public static final String SPRING_CONFIG_FILE_NAMES_SETTING = "springConfigFileNames";
    private static final String SPRING_CONFIG_FILE_NAME = "spring-application.xml";
    private DWResourcePatternResolver dwResourceLoader = new DWResourcePatternResolver();

    public DWSimplifiedSpringXMLResourceReader(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public ResourceLoader getResourceLoader() {
        return this.dwResourceLoader;
    }

    private DWSimplifiedSpringResource createResource(String fileName, String fileContent, ClassLoader classLoader) {
        DWSimplifiedSpringResource resource = null;
        if (fileContent != null && fileContent.length() > 0) {
            resource = new DWSimplifiedSpringResource(fileName, fileContent, classLoader);
        }
        return resource;
    }

    private void logSpringXMLReadToLoad(String groupName, String resourceLocation, int seq, String fileName) {
        String message = groupName == null || groupName.isEmpty() ? String.format("> %s No.%s Spring XML: %s", resourceLocation, seq, fileName) : String.format("Group %s> %s No.%s Spring XML: %s", groupName, resourceLocation, seq, fileName);
        log.info((Object)message);
    }

    public class DWResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        public Resource[] getResources(String locationPattern) throws IOException {
            ConfigPool configPool = ConfigPool.getInstance();
            ClassLoader classLoader = DWSimplifiedSpringXMLResourceReader.class.getClassLoader();
            if (locationPattern.equals(DWSimplifiedSpringXMLResourceReader.DW_PLATFORM_PROPERTIES_URL)) {
                String platformXMLs = DWSimplifiedSpringXMLResourceReader.this.getEnvironment().getProperty(DWSimplifiedSpringXMLResourceReader.CONFIG_KEY_PLATFORM_SPRING_XML_FILE_NAMES);
                ArrayList<DWSimplifiedSpringResource> resources = new ArrayList<DWSimplifiedSpringResource>();
                List<String> springConfigs = this.getServerSpringConfigs(DWSimplifiedSpringXMLResourceReader.DW_PLATFORM_PROPERTIES_URL, platformXMLs);
                if (springConfigs != null) {
                    Iterator<String> iterator = springConfigs.iterator();
                    while (iterator.hasNext()) {
                        String config;
                        String xmlString = FilenameUtils.getExtension((String)(config = iterator.next())).length() > 0 ? configPool.getResource(config) : configPool.getPlatformSpringXml(config);
                        DWSimplifiedSpringResource resource = DWSimplifiedSpringXMLResourceReader.this.createResource(config, xmlString, classLoader);
                        if (resource == null) continue;
                        resources.add(resource);
                    }
                }
                Resource[] rsArray = new Resource[resources.size()];
                rsArray = resources.toArray(rsArray);
                return rsArray;
            }
            if (locationPattern.equals(DWSimplifiedSpringXMLResourceReader.DW_APPLICATION_PROPERTIES_URL)) {
                ArrayList<DWSimplifiedSpringResource> resources = new ArrayList<DWSimplifiedSpringResource>();
                String applicationXMLs = DWSimplifiedSpringXMLResourceReader.this.getEnvironment().getProperty("springConfigFileNames");
                List<String> springConfigs = this.getServerSpringConfigs(DWSimplifiedSpringXMLResourceReader.DW_APPLICATION_PROPERTIES_URL, applicationXMLs);
                if (springConfigs == null) {
                    String xmlString = configPool.getApplicationSpringXml("spring");
                    DWSimplifiedSpringResource resource = DWSimplifiedSpringXMLResourceReader.this.createResource("Application Layer Default Spring XML", xmlString, classLoader);
                    if (resource != null) {
                        resources.add(resource);
                    }
                    DWSimplifiedSpringXMLResourceReader.this.logSpringXMLReadToLoad(null, DWSimplifiedSpringXMLResourceReader.DW_APPLICATION_PROPERTIES_URL, 0, "Application layer spring");
                } else {
                    for (String config : springConfigs) {
                        DWSimplifiedSpringResource resource;
                        String xmlString;
                        Object resourceName;
                        if (FilenameUtils.getExtension((String)config).length() > 0) {
                            resourceName = config;
                            xmlString = configPool.getResource(config);
                        } else {
                            resourceName = "Application Layer Spring XML, Name = " + config;
                            xmlString = configPool.getApplicationSpringXml(config);
                        }
                        if ((resource = DWSimplifiedSpringXMLResourceReader.this.createResource((String)resourceName, xmlString, classLoader)) == null) continue;
                        resources.add(resource);
                    }
                }
                Resource[] rsArray = new Resource[resources.size()];
                rsArray = resources.toArray(rsArray);
                return rsArray;
            }
            if (locationPattern.startsWith(DWSimplifiedSpringXMLResourceReader.DW_RESOURCE_URL_PREFIX)) {
                String resourceString;
                String resourceName = locationPattern.split(DWSimplifiedSpringXMLResourceReader.DW_RESOURCE_URL_PREFIX)[1];
                DWSimplifiedSpringResource resource = DWSimplifiedSpringXMLResourceReader.this.createResource(resourceName, resourceString = ConfigPool.getInstance().getResource(resourceName), classLoader);
                if (resource == null) {
                    return new Resource[0];
                }
                return new Resource[]{resource};
            }
            if (locationPattern.equals(DWSimplifiedSpringXMLResourceReader.DW_GROUP_DEFAULT_SPRING_XML_URL)) {
                return this.getGroupSpringXMLResources();
            }
            return super.getResources(locationPattern);
        }

        private List<Resource> getGroupSpringXMLResources(String groupName) throws UnsupportedEncodingException {
            ClassLoader classLoader = DWSimplifiedSpringXMLResourceReader.class.getClassLoader();
            String xmlFiles = DWModuleConfigUtils.getProperty((String)groupName, (String)"springConfigFileNames", null);
            List<String> springConfigs = this.getServerSpringConfigs(groupName, DWSimplifiedSpringXMLResourceReader.DW_GROUP_DEFAULT_SPRING_XML_URL, xmlFiles);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            if (springConfigs == null) {
                springConfigs = Collections.singletonList("spring-module.xml");
                DWSimplifiedSpringXMLResourceReader.this.logSpringXMLReadToLoad(groupName, DWSimplifiedSpringXMLResourceReader.DW_GROUP_DEFAULT_SPRING_XML_URL, 0, springConfigs.get(0));
            }
            ConfigPool configPool = ConfigPool.getInstance();
            for (String config : springConfigs) {
                String xmlString = configPool.getModuleSpringXml(groupName, config);
                String resourceDescription = Objects.equals("spring-module.xml", config) ? String.format("Group [%s] Default Spring XML", groupName) : String.format("Group [%s] Spring XML, name = %s", groupName, config);
                DWSimplifiedSpringResource resource = DWSimplifiedSpringXMLResourceReader.this.createResource(resourceDescription, xmlString, classLoader);
                if (resource == null) {
                    log.warn((Object)String.format("%s Resource is not exist!", resourceDescription));
                    continue;
                }
                resources.add((Resource)resource);
            }
            return resources;
        }

        private Resource[] getGroupSpringXMLResources() throws UnsupportedEncodingException {
            List groupNames = DWSimplifiedResourceManager.getGroupNameList();
            ArrayList<Resource> allResources = new ArrayList<Resource>();
            for (String groupName : groupNames) {
                allResources.addAll(this.getGroupSpringXMLResources(groupName));
            }
            return (Resource[])allResources.stream().toArray(Resource[]::new);
        }

        private List<String> getServerSpringConfigs(String resourceLocation, String xmlFiles) {
            return this.getServerSpringConfigs(null, resourceLocation, xmlFiles);
        }

        private List<String> getServerSpringConfigs(String groupName, String resourceLocation, String xmlFiles) {
            String[] fileNamesArray;
            if (xmlFiles == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            if (StringUtils.isBlank((String)xmlFiles)) {
                return result;
            }
            for (String fileName : fileNamesArray = xmlFiles.split(",")) {
                result.add(fileName);
            }
            for (int i = 0; i < result.size(); ++i) {
                String eachConfigFileName = (String)result.get(i);
                DWSimplifiedSpringXMLResourceReader.this.logSpringXMLReadToLoad(groupName, resourceLocation, i, eachConfigFileName);
            }
            return result;
        }
    }
}

