/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GatewayController {
    @Autowired
    private DWContainerContext containerContext;

    public Object execute() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWServiceContext.getContext().setRequestURI(httpRequest.getRequestURI());
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWParameters apiParameters = (DWParameters)httpRequest.getAttribute("targetParameters");
        Object result = this.containerContext.invoke(api, apiParameters, profile);
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        result = handler.process(result);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        int statusCode = DWServiceContext.getContext().getStatusCode();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)statusCode).headers(responseHeaders)).body(result);
    }

    public Object restful() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWRestfulParameters restfulParameters = (DWRestfulParameters)httpRequest.getAttribute("targetParameters");
        Object result = this.containerContext.invoke(api, (DWParameters)restfulParameters, profile);
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        result = handler.process(result);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        int statusCode = DWServiceContext.getContext().getStatusCode();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)statusCode).headers(responseHeaders)).body(result);
    }
}

