/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.result.DWResultHandlerList;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class ServiceInvoker {
    private static final String TIMEOUT_MESSAGE = "timeout";
    private static final long DEFAULT_TIMEOUT = 120000L;
    @Autowired
    private DWContainerContext containerContext;

    public DeferredResult<Object> eai(String digiSrvver, DWHeader header, DWMethod method, String moduleName, String serviceName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        HttpServletResponse response = this.getResponse();
        new Thread(() -> {
            Object result = null;
            try {
                result = this.containerContext.invokeEai(header, method, moduleName, serviceName, parameters, profile);
                response.addHeader("digi-srvver", digiSrvver);
                response.addHeader("digi-srvcode", "000");
                deferredResult.setResult(result);
            }
            catch (Throwable e) {
                response.addHeader("digi-srvver", digiSrvver);
                response.addHeader("digi-srvcode", "100");
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    public DeferredResult<Object> restful(DWRestfulHeader header, String moduleName, String serviceName, DWRestfulParameters restfulParameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        DWServiceContext context = DWServiceContext.getContext();
        new Thread(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                Object result = this.containerContext.invokeRestful(header, moduleName, serviceName, restfulParameters, profile);
                DWResultHandlerList handler = DWResultHandlerList.getInstance();
                result = handler.process(result);
                Map headerMap = DWServiceContext.getContext().getResponseHeader();
                HttpHeaders responseHeaders = new HttpHeaders();
                for (String key : headerMap.keySet()) {
                    responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
                }
                deferredResult.setResult((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result));
            }
            catch (Throwable e) {
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    public DeferredResult<Object> service(String moduleName, String serviceName, String methodName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        DWServiceContext context = DWServiceContext.getContext();
        new Thread(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                Object result = this.containerContext.invoke(moduleName, serviceName, methodName, parameters, profile);
                DWResultHandlerList handler = DWResultHandlerList.getInstance();
                result = handler.process(result);
                Map headerMap = DWServiceContext.getContext().getResponseHeader();
                HttpHeaders responseHeaders = new HttpHeaders();
                for (String key : headerMap.keySet()) {
                    responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
                }
                deferredResult.setResult((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result));
            }
            catch (Throwable e) {
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    private DeferredResult<Object> getDeferredResult() throws Exception {
        long timeout = this.getTimeout();
        Object timeoutResult = this.getTimeoutResult();
        DeferredResult deferredResult = new DeferredResult(Long.valueOf(timeout), timeoutResult);
        return deferredResult;
    }

    private Object getTimeoutResult() throws Exception {
        Object timeoutResult = DWResultHandlerList.getInstance().process(TIMEOUT_MESSAGE);
        return timeoutResult;
    }

    private long getTimeout() {
        String timeout = DWApplicationConfigUtils.getProperty((String)"serverAsyncTimeout", (String)String.valueOf(120000L));
        return Long.valueOf(timeout);
    }

    private HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        return response;
    }

    private String getThreadName() {
        return "DWWorker-" + UUID.randomUUID().toString();
    }
}

