/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWInitEntryPointConfig {
    public static final String API_INITIALIZATION = "/api/app/initialize";
    private static Map<DWInitializationEvent, Integer> initEventMap;

    public static void register(DWInitializationEvent event) throws Exception {
        DWInitEntryPointConfig.register(event, Integer.MAX_VALUE);
    }

    public static void register(DWInitializationEvent event, int order) throws Exception {
        if (event == null) {
            throw new DWArgumentException("event", "event is null!");
        }
        initEventMap.put(event, order);
    }

    public static List<DWInitializationEvent> getInitEventList() {
        LinkedHashMap sortedMap = initEventMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<DWInitializationEvent> sortedList = new ArrayList<DWInitializationEvent>(sortedMap.keySet());
        return sortedList;
    }

    public static Integer getOrder(DWInitializationEvent event) {
        return initEventMap.get(event);
    }

    static {
        StandardHeaderFilter.addExtraUrlPatterns((String[])new String[]{API_INITIALIZATION});
        initEventMap = new HashMap<DWInitializationEvent, Integer>();
    }
}

