/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.eai;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@ConditionalOnClass(value={DWEAIHeaderRepository.class})
public class DWEAIAutoRegistration {
    private static Log log = LogFactory.getLog(DWEAIAutoRegistration.class);

    public DWEAIAutoRegistration() {
        try {
            log.info((Object)("EAI Services is enabled...: " + this.isEAIAutoRegistrationEnabled()));
            Map<String, String> env = System.getenv();
            String appImageName = MapUtils.getString(env, (Object)"APPIMAGENAME", (String)"");
            log.info((Object)("appImageName: " + appImageName));
            if (StringUtils.isBlank((CharSequence)appImageName)) {
                log.info((Object)"EAI Services don't need to registered.");
                return;
            }
            if (this.isEAIAutoRegistrationEnabled()) {
                this.auotRegister();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to register EAI Services: " + e));
        }
    }

    public void auotRegister() throws Exception {
        Map<Object, Object> result = new HashMap();
        log.info((Object)"EAI Services start auto-registering...");
        DWEAIHeaderRepository eaiHeaderRepository = (DWEAIHeaderRepository)SpringContextUtils.getBean((String)"DWEAIHeaderRepository");
        result = this.getSrvRegInfo(eaiHeaderRepository.getEaiServiceIdList());
        HttpPost post = new HttpPost(this.getEAIRegSrvURL());
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.addHeader("connection", "close");
        String jsonString = DWGsonProvider.getGson().toJson(result, result.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)stringEntity);
        post.setEntity((HttpEntity)stringEntity);
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            log.error((Object)"Something wrong in the process of eai services auto-registration...");
            log.error((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
        } else {
            log.info((Object)"EAI Services have rigistered automatically.");
        }
    }

    public Map<String, Object> getSrvRegInfo(List<String> serviceIdList) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, List<String>> service = new HashMap<String, List<String>>();
        service.put("srvname", serviceIdList);
        result.put("service", service);
        this.attachHostInfo(result);
        return result;
    }

    public Map<String, String> attachHostInfo(Map<String, Object> resultMap) throws UnknownHostException {
        Map<String, String> hostInfo = this.getHostBasicInfo();
        resultMap.put("host", hostInfo);
        return hostInfo;
    }

    public Map<String, String> getHostBasicInfo() throws UnknownHostException {
        String ip = this.getHostIP();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        String prod = DWApplicationConfigUtils.getProperty((String)"eaiHostProd", (String)appId);
        String ver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        String id = DWApplicationConfigUtils.getProperty((String)"eaiHostId", (String)appId);
        String uid = DWApplicationConfigUtils.getProperty((String)"eaiHostUid", (String)appId);
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        return host;
    }

    private String getHostIP() throws UnknownHostException {
        String defaultIp = InetAddress.getLocalHost().getHostAddress();
        String ip = DWApplicationConfigUtils.getProperty((String)"eaiHostIp", (String)defaultIp);
        return ip;
    }

    public String getEAIRegSrvURL() {
        String host = DWApplicationConfigUtils.getProperty((String)"eaiUrl");
        String url = DWApplicationConfigUtils.getProperty((String)"eaiUrlRegSrv", (String)"/CROSS/RESTful/regSrv");
        log.info((Object)("CROSS Server Host:" + host));
        return host + url;
    }

    private boolean isEAIAutoRegistrationEnabled() {
        String enabled = DWApplicationConfigUtils.getProperty((String)"eaiAutoRegistrationEnable");
        log.info((Object)("Value of eaiAutoRegistrationEnable:" + enabled));
        return StringUtils.equals((CharSequence)"true", (CharSequence)StringUtils.trim((String)enabled));
    }
}

