/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Profile(value={"bio"})
public class GatewayController {
    @Autowired
    private DWContainerContext containerContext;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.DELETE}, path={"/restful/service/**"})
    public Object execute() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWServiceContext.getContext().setRequestURI(httpRequest.getRequestURI());
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWParameters apiParameters = (DWParameters)httpRequest.getAttribute("targetParameters");
        Object result = this.containerContext.invoke(api, apiParameters, profile);
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        result = handler.process(result);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result);
    }

    @RequestMapping(path={"/restful/standard/**"})
    public Object restful() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWRestfulParameters restfulParameters = (DWRestfulParameters)httpRequest.getAttribute("targetParameters");
        Object result = this.containerContext.invoke(api, (DWParameters)restfulParameters, profile);
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        result = handler.process(result);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result);
    }
}

