/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.gateway.filter.EaiRestfulUrlUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class EaiInfoUtils {
    private static Log log = LogFactory.getLog(EaiInfoUtils.class);

    public static Map<String, Object> getSrvRegInfo(Supplier<List<String>> serviceIdSupplier) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, List<String>> service = new HashMap<String, List<String>>();
        service.put("srvname", serviceIdSupplier.get());
        result.put("service", service);
        EaiInfoUtils.attachHostInfo(result);
        return result;
    }

    public static Map<String, Object> getProdRegInfo(Environment environment) throws Exception {
        String concurrence;
        String retryInterval;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, String> hostInfoMap = EaiInfoUtils.attachHostInfo(result);
        String offset = EaiInfoUtils.getTimezoneOffset();
        hostInfoMap.put("timezone", offset);
        String ip = EaiInfoUtils.getHostIP();
        String port = environment.getProperty("local.server.port");
        hostInfoMap.put("restful", "http://" + ip + ":" + port + EaiRestfulUrlUtils.getUrl());
        String retryTimes = DWApplicationConfigUtils.getProperty((String)"eaiHostRetrytimes", (String)"");
        if (!StringUtils.isBlank((CharSequence)retryTimes)) {
            hostInfoMap.put("retrytimes", retryTimes);
        }
        if (!StringUtils.isBlank((CharSequence)(retryInterval = DWApplicationConfigUtils.getProperty((String)"eaiHostRetryinterval", (String)"")))) {
            hostInfoMap.put("retryinterval", retryInterval);
        }
        if (!StringUtils.isBlank((CharSequence)(concurrence = DWApplicationConfigUtils.getProperty((String)"eaiHostConcurrence", (String)"")))) {
            hostInfoMap.put("concurrence", concurrence);
        }
        return result;
    }

    public static Map<String, String> attachHostInfo(Map<String, Object> resultMap) throws UnknownHostException {
        Map<String, String> hostInfo = EaiInfoUtils.getHostBasicInfo();
        resultMap.put("host", hostInfo);
        return hostInfo;
    }

    public static Map<String, String> getHostBasicInfo() throws UnknownHostException {
        String ip = EaiInfoUtils.getHostIP();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        String prod = DWApplicationConfigUtils.getProperty((String)"eaiHostProd", (String)appId);
        String ver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        String id = DWApplicationConfigUtils.getProperty((String)"eaiHostId", (String)appId);
        String uid = DWApplicationConfigUtils.getProperty((String)"eaiHostUid", (String)appId);
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        return host;
    }

    private static String getHostIP() throws UnknownHostException {
        String defaultIp = InetAddress.getLocalHost().getHostAddress();
        String ip = DWApplicationConfigUtils.getProperty((String)"eaiHostIp", (String)defaultIp);
        return ip;
    }

    private static String getTimezoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        int offsetInMillis = timeZone.getOffset(calendar.getTimeInMillis());
        String offset = String.format("%d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request;
    }

    public static HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        return response;
    }

    public static String getEAIRegSrvURL() {
        String host = DWApplicationConfigUtils.getProperty((String)"eaiUrl");
        String url = DWApplicationConfigUtils.getProperty((String)"eaiUrlRegSrv", (String)"/CROSS/RESTful/regSrv");
        log.info((Object)("CROSS Server Host:" + host));
        return host + url;
    }
}

