/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.DWDataSourceConstants;
import com.digiwin.app.dao.datasource.DWTenantRoutingDataSource;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.gateway.event.DWDataSourceEvent;
import com.digiwin.gateway.event.DWDataSourceEventConfig;
import com.digiwin.gateway.event.DWDataSourceEventParameters;
import com.digiwin.gateway.event.DWDataSourceEventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWDataSourceEventImpl
implements DWDataSourceEvent {
    private static final Log _log = LogFactory.getLog(DWDataSourceEventImpl.class);
    private static final String _CLASSTAG = "[DWDataSourceEventImpl] ";
    private static final String _key_dataSourceName = "DWAbstractTenantDataSource";
    private static final String _key_routingDataSourceName = "AbstractRoutingDataSource";

    private static void staticInitializer() {
        DWDataSourceEventConfig.register(new DWDataSourceEventImpl());
    }

    @Override
    public DWDataSourceEventResult doInvoke(DWDefaultParameters params) throws Exception {
        return this.invokeDataSourceUpdate(params);
    }

    private DWDataSourceEventResult invokeDataSourceUpdate(DWDefaultParameters params) throws Exception {
        String resultMsg = "";
        _log.debug((Object)"[DWDataSourceEventImpl] update starting...");
        List<String> moduleNames = ((DWDataSourceEventParameters)params).getData();
        Map<String, Object> data = this.updateTenantDataSource(this.filterLoadedModules(moduleNames));
        _log.debug((Object)"[DWDataSourceEventImpl] update finished");
        DWDataSourceEventResult eventResult = new DWDataSourceEventResult(this, true, resultMsg, data);
        return eventResult;
    }

    public Map<String, Object> updateTenantDataSource(List<String> moduleNames) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        _log.debug((Object)("[DWDataSourceEventImpl] need to update " + moduleNames.size() + " module(s)"));
        for (String moduleName : moduleNames) {
            _log.debug((Object)(_CLASSTAG + moduleName + " processing..."));
            HashMap<String, Object> moduleResult = new HashMap<String, Object>();
            boolean moduleUpdateSuccess = true;
            if (DWModuleSpringUtils.getSpringContexts().containsKey(moduleName)) {
                HashMap<String, String> updateResult = new HashMap<String, String>();
                ApplicationContext moduleSpringContext = DWModuleSpringUtils.getModuleSpringContext((String)moduleName);
                DWAbstractTenantDataSource tenantDSBean = (DWAbstractTenantDataSource)moduleSpringContext.getBean(DWAbstractTenantDataSource.class);
                DWTenantRoutingDataSource routingDSBean = (DWTenantRoutingDataSource)moduleSpringContext.getBean(DWTenantRoutingDataSource.class);
                if (tenantDSBean != null && routingDSBean != null) {
                    tenantDSBean.initialize(moduleName);
                    routingDSBean.setMultipleDataSources(tenantDSBean);
                    updateResult.put(_key_dataSourceName, tenantDSBean.getClass().getName());
                    updateResult.put(_key_routingDataSourceName, routingDSBean.getClass().getName());
                } else {
                    moduleUpdateSuccess = false;
                    updateResult.put("message", "required bean(s) is not existed");
                    String beanName = null;
                    if (tenantDSBean != null) {
                        beanName = tenantDSBean.getClass().getName();
                    }
                    updateResult.put(_key_dataSourceName, beanName);
                    beanName = null;
                    if (routingDSBean != null) {
                        beanName = routingDSBean.getClass().getName();
                    }
                    updateResult.put(_key_routingDataSourceName, beanName);
                }
                moduleResult.put("data", updateResult);
                moduleResult.put("success", moduleUpdateSuccess);
                result.put(moduleName, moduleResult);
                continue;
            }
            String message = _CLASSTAG + moduleName + " can not find key in SpringContexts, maybe not loaded yet";
            moduleResult.put("message", message);
            moduleResult.put("success", moduleUpdateSuccess);
            result.put(moduleName, moduleResult);
            _log.warn((Object)message);
        }
        return result;
    }

    private List<String> filterLoadedModules(List<String> requestModules) {
        List<Object> moduleNames = new ArrayList();
        if (requestModules != null && requestModules.size() == 1 && "*".equals(requestModules.get(0))) {
            Set loadedModules = DWModuleSpringUtils.getSpringContexts().keySet();
            moduleNames = loadedModules.stream().collect(Collectors.toList());
        } else {
            moduleNames = requestModules;
        }
        moduleNames.removeAll(DWDataSourceConstants.KEY_MULTIPLE_SYS_MODULES);
        return moduleNames;
    }

    static {
        DWDataSourceEventImpl.staticInitializer();
    }
}

