/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import com.digiwin.app.common.DWApplicationConfigUtils;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;

public class DWAutoConfigurationImportFilter
implements AutoConfigurationImportFilter {
    private static Set<String> excludeAutoConfiguration = new HashSet<String>();

    private static void staticInitializer() {
        if (DWApplicationConfigUtils.isClosedDB()) {
            excludeAutoConfiguration.add("org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration");
        }
        if (DWApplicationConfigUtils.isClosedSchedule()) {
            excludeAutoConfiguration.add("org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration");
        }
    }

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        boolean[] matches = new boolean[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            matches[i] = !excludeAutoConfiguration.contains(autoConfigurationClasses[i]);
        }
        return matches;
    }

    static {
        DWAutoConfigurationImportFilter.staticInitializer();
    }
}

