/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.controller.ServiceInvoker;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
public class EaiNioController {
    @Autowired
    private ServiceInvoker serviceInvoker;
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    Environment environment;

    public DeferredResult<Object> callback() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
        DWParameters invokeParameters = (DWParameters)request.getAttribute("targetParameters");
        DeferredResult<Object> deferredResult = this.serviceInvoker.eai(api, digiSrvver, invokeParameters, profile);
        return deferredResult;
    }

    public DeferredResult<Object> eai() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
        DWParameters invokeParameters = (DWParameters)request.getAttribute("targetParameters");
        DeferredResult<Object> deferredResult = this.serviceInvoker.eai(api, digiSrvver, invokeParameters, profile);
        return deferredResult;
    }

    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList());
                break;
            }
            case "doSyncProcess": {
                response.addHeader("digi-srvcode", "000");
                break;
            }
        }
        return result;
    }
}

