/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.Ordered;

public class ApplicationStartup
implements CommandLineRunner,
Ordered {
    private List<CommandLineRunner> runners;

    public ApplicationStartup(List<CommandLineRunner> runners) {
        this.runners = runners;
    }

    public void run(String ... args) throws Exception {
        Collections.sort(this.runners, Comparator.comparingInt(runner -> ((Ordered)runner).getOrder()));
        Log log = LogFactory.getLog(ApplicationStartup.class);
        log.info((Object)String.format("DAP-ApplicationStartup ready to run all command line runners(size=%s)...", this.runners.size()));
        int i = 0;
        for (CommandLineRunner runner2 : this.runners) {
            log.info((Object)String.format("DAP-ApplicationStartup run seq=%s, runner class=%s", ++i, runner2.getClass().getName()));
            runner2.run(new String[]{"run"});
        }
    }

    public int getOrder() {
        return 0;
    }
}

