/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing.interceptor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import com.digiwin.gateway.tracing.DWTracing;
import com.digiwin.gateway.tracing.DWTracingContext;
import com.digiwin.gateway.tracing.handler.DWTracerHandler;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response;
        block19: {
            String serviceUrl = request.getURI().toURL().toString();
            if (DWTracingContext.getInstance().isTracingEnable()) {
                DWTracing dwTracing = new DWTracing("api:" + serviceUrl);
                Tracing tracing = dwTracing.getCurrentTracing();
                DWTracerHandler dwTracerHandler = new DWTracerHandler(tracing);
                Tracer tracer = dwTracerHandler.getTracer();
                Span span = tracer.nextSpan().name("restTemplate");
                try (Tracer.SpanInScope ws = tracer.withSpanInScope(span.start());){
                    span.kind(Span.Kind.CLIENT);
                    span.tag("url", serviceUrl);
                    dwTracerHandler.handleSend(request);
                    response = execution.execute(request, body);
                    break block19;
                }
                catch (Exception e) {
                    if (null != e.getMessage()) {
                        span.error((Throwable)e);
                    }
                    throw e;
                }
                finally {
                    span.finish();
                }
            }
            response = execution.execute(request, body);
        }
        return response;
    }
}

