/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing.filter;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.servlet.HttpServletAdapter;
import com.digiwin.gateway.tracing.DWTracing;
import com.digiwin.gateway.tracing.DWTracingContext;
import com.digiwin.gateway.tracing.handler.DWTracerHandler;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DWTracingFilter
implements Filter {
    Tracing tracing;
    static final HttpServletAdapter ADAPTER = new HttpServletAdapter();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block22: {
            String[] urlArray;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String url = httpRequest.getRequestURI();
            String[] urlFullArray = url.split("/restful/service");
            String servicePartialUrl = "";
            if (urlFullArray.length >= 1) {
                servicePartialUrl = urlFullArray[1];
                urlArray = servicePartialUrl.split("/");
            } else {
                urlArray = url.split("/");
            }
            HashMap<String, String> spanTagInitMap = new HashMap<String, String>();
            String serviceUrl = url;
            int urlPatternLength = urlArray.length;
            if (urlPatternLength > 3) {
                String moduleName = urlArray[urlPatternLength - 3];
                String serviceName = urlArray[urlPatternLength - 2];
                String methodName = urlArray[urlPatternLength - 1];
                spanTagInitMap.put("module", moduleName);
                spanTagInitMap.put("service", serviceName);
                spanTagInitMap.put("method", methodName);
                serviceUrl = "/" + moduleName + "/" + serviceName + "/" + methodName;
            }
            String tracingServiceName = "api:" + serviceUrl;
            if (DWTracingContext.getInstance().isTracingEnable()) {
                DWTracing dwTracing = new DWTracing(tracingServiceName);
                this.tracing = dwTracing.getCurrentTracing();
                DWTracerHandler dwTracerHandler = new DWTracerHandler(this.tracing);
                Tracer tracer = dwTracerHandler.getTracer();
                Span span = dwTracerHandler.handleReceive(httpRequest).name("filter");
                span.kind(Span.Kind.SERVER);
                try (Tracer.SpanInScope ws = tracer.withSpanInScope(span.start());){
                    spanTagInitMap.put("appName", System.getProperty("appName", "no-setting"));
                    dwTracerHandler.reportSpanWithInfo("init", "span-init", spanTagInitMap);
                    chain.doFilter(request, response);
                    dwTracerHandler.reportSpanWithInfo("finish", "span-finish", null);
                    break block22;
                }
                catch (Exception e) {
                    if (null != e.getMessage()) {
                        span.error((Throwable)e);
                    }
                    throw e;
                }
                finally {
                    int httpStatusCode = httpResponse.getStatus();
                    span.tag("http.status", String.valueOf(httpStatusCode));
                    span.finish();
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        if (this.tracing != null) {
            this.tracing.close();
        }
    }
}

