/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing.handler;

import brave.ScopedSpan;
import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.digiwin.gateway.tracing.handler.TracerHandler;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;

public class DWTracerHandler
implements TracerHandler {
    private Logger logger = LoggerFactory.getLogger(DWTracerHandler.class);
    DWTracerHandler dwTacerHandler;
    static Tracing tracing;
    Tracer tracer;
    private static TraceContext.Extractor<Map<String, String>> extractor;
    private static TraceContext.Injector<Map<String, String>> injector;
    static final Propagation.Getter<Map<String, String>, String> GETTER;
    static final Propagation.Setter<Map<String, String>, String> SETTER;
    Map<String, String> spanMap = new HashMap<String, String>();

    public Map<String, String> getSpanMap() {
        return this.spanMap;
    }

    public void setSpanMap(Map<String, String> spanMap) {
        this.spanMap = spanMap;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public DWTracerHandler(Tracing tracing) {
        DWTracerHandler.tracing = tracing;
        this.tracer = tracing.tracer();
    }

    public Span createSpanAndRegisterInfo(Map<String, String> spanMap, Map<String, String> infoMap, String spanName) {
        Span span = spanMap == null || spanMap.size() == 0 ? this.tracer.newTrace().name(spanName) : this.tracer.nextSpan().name(spanName);
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
            for (String key : infoMap.keySet()) {
                span.tag(key, infoMap.get(key));
            }
            span.annotate("flush");
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            if (span != null) {
                span.flush();
            }
        }
        return span;
    }

    public void joinSpan(Map<String, String> spanMap) {
    }

    public void reportSpanWithInfo(String spanName, @Nullable String annoString, @Nullable Map<String, String> tagMap) {
        ScopedSpan scopedSpan = this.tracer.startScopedSpan(spanName);
        if (tagMap != null) {
            for (String key : tagMap.keySet()) {
                scopedSpan.tag(key, tagMap.get(key));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)annoString)) {
            scopedSpan.annotate(annoString);
        }
        scopedSpan.finish();
    }

    public Span createSpan(@Nullable Map<String, String> spanMap, @Nullable Map<String, String> infoMap, String spanName) {
        Span span = this.tracer.nextSpan().name(spanName);
        span.kind(Span.Kind.SERVER).start();
        return span;
    }

    @Override
    public Map<String, String> extractor(Span span, Propagation<String> propagation) {
        HashMap<String, String> spanMap = new HashMap<String, String>();
        for (String key : propagation.keys()) {
            String value = "";
            if (!key.startsWith("X-B3")) continue;
            switch (key) {
                case "X-B3-TraceId": {
                    value = span.context().traceIdString();
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-ParentSpanId": {
                    value = span.context().parentIdString();
                    if (value == null) {
                        value = "0";
                    }
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-SpanId": {
                    value = span.context().spanIdString();
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-Sampled": {
                    value = String.valueOf(BooleanUtils.toInteger((boolean)span.context().sampled()));
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-Flags": {
                    value = new Boolean(span.context().debug()).toString();
                    spanMap.put(key, value);
                    break;
                }
            }
        }
        return spanMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSend(Span span, HttpServletResponse httpResponse) {
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            int httpStatusCode = httpResponse.getStatus();
            span.tag("http.status", String.valueOf(httpStatusCode));
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Span span, HttpServletResponse httpResponse) {
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            int httpStatusCode = httpResponse.getStatus();
            span.tag("http.status", String.valueOf(httpStatusCode));
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public Map<String, String> extractor(HttpServletRequest httpRequest, Propagation<String> propagation) {
        HashMap<String, String> spanMap = new HashMap<String, String>();
        for (String key : propagation.keys()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"X-B3")) continue;
            String value = httpRequest.getHeader(key);
            switch (key) {
                case "X-B3-TraceId": {
                    if (!StringUtils.isNotBlank((CharSequence)value)) break;
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-ParentSpanId": {
                    if (!StringUtils.isNotBlank((CharSequence)value)) break;
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-SpanId": {
                    if (!StringUtils.isNotBlank((CharSequence)value)) break;
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-Sampled": {
                    if (!StringUtils.isNotBlank((CharSequence)value)) break;
                    spanMap.put(key, value);
                    break;
                }
                case "X-B3-Flags": {
                    if (!StringUtils.isNotBlank((CharSequence)value)) break;
                    value = new Boolean(httpRequest.getHeader(key)).toString();
                    spanMap.put(key, value);
                }
            }
        }
        return spanMap;
    }

    @Override
    public Span handleRequest(Map<String, String> spanMap) {
        extractor = tracing.propagation().extractor(GETTER);
        TraceContextOrSamplingFlags extracted = extractor.extract(spanMap);
        TraceContext traceContext = extracted.context();
        Span span = traceContext != null ? this.tracer.joinSpan(traceContext) : this.tracer.nextSpan(extracted);
        return span;
    }

    @Override
    public void handleSend(HttpRequest httpRequest) {
        extractor = tracing.propagation().extractor(GETTER);
        TraceContextOrSamplingFlags extracted = extractor.extract(this.spanMap);
        TraceContext traceContext = extracted.context();
        Span span = traceContext != null ? this.tracer.joinSpan(traceContext) : this.tracer.nextSpan(extracted);
        this.spanMap = this.extractor(span, (Propagation<String>)Tracing.current().propagation());
        httpRequest.getHeaders().setAll(this.spanMap);
    }

    @Override
    public Span handleReceive(HttpServletRequest httpRequest) {
        this.spanMap = this.extractor(httpRequest, (Propagation<String>)Tracing.current().propagation());
        extractor = tracing.propagation().extractor(GETTER);
        TraceContextOrSamplingFlags extracted = extractor.extract(this.spanMap);
        TraceContext traceContext = extracted.context();
        if (traceContext != null) {
            this.logger.debug("traceContext is NOT NULL");
        }
        Span span = traceContext != null ? this.tracer.joinSpan(traceContext) : this.tracer.newTrace();
        this.logger.debug(httpRequest.getRequestURI() + ", traceId=" + span.context().traceIdString());
        return span;
    }

    static {
        GETTER = new Propagation.Getter<Map<String, String>, String>(){

            public String get(Map<String, String> carrier, String key) {
                return carrier.get(key);
            }

            public String toString() {
                return "Map::get";
            }
        };
        SETTER = new Propagation.Setter<Map<String, String>, String>(){

            public void put(Map<String, String> carrier, String key, String value) {
                carrier.put(key, value);
            }

            public String toString() {
                return "Map::set";
            }
        };
    }
}

