/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.route;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.route.ApolloScopleProcess;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class DefaultApolloScopleProcess
implements ApolloScopleProcess,
ConfigChangeListener {
    private static final String APOLLO_LOCAL_ROUTE_SUFIX = "lr";
    private static final String DEFAULT_LOCAL_HOST_KEY = "@default@";
    private final String prodName;
    private final Config config;
    private final Map<String, String> routeMapHost = new ConcurrentHashMap<String, String>();
    private boolean effective = false;
    private String defaultHost = null;

    public DefaultApolloScopleProcess(String prodName) {
        this.prodName = prodName;
        this.config = ConfigService.getConfig((String)(this.prodName + "_" + APOLLO_LOCAL_ROUTE_SUFIX));
        this.config.addChangeListener((ConfigChangeListener)this);
        this.update();
    }

    @Override
    public String getHost(String routeKey) {
        if (this.effective) {
            if (StringUtils.isBlank((CharSequence)routeKey)) {
                return this.defaultHost;
            }
            return this.routeMapHost.getOrDefault(routeKey, this.defaultHost);
        }
        return null;
    }

    public void onChange(ConfigChangeEvent changeEvent) {
        this.update();
    }

    private synchronized void update() {
        AtomicReference newDefaultHost = new AtomicReference();
        HashMap<String, String> addedMap = new HashMap<String, String>();
        HashMap<String, String> modifyMap = new HashMap<String, String>();
        HashSet<String> deleteKeys = new HashSet<String>();
        for (String string : this.config.getPropertyNames()) {
            String[] tenantIds;
            for (String tenantId : tenantIds = (String[])this.config.getProperty(string, value -> {
                if (DEFAULT_LOCAL_HOST_KEY.equals(value)) {
                    newDefaultHost.set(host);
                    return new String[0];
                }
                return value.split(",");
            }, (Object)new String[0])) {
                if (!this.routeMapHost.containsKey(tenantId)) {
                    addedMap.put(tenantId, string);
                    continue;
                }
                if (!this.routeMapHost.containsKey(tenantId) || string.equals(this.routeMapHost.get(tenantId))) continue;
                modifyMap.put(tenantId, string);
            }
        }
        for (String string : this.routeMapHost.keySet()) {
            if (addedMap.containsKey(string) || modifyMap.containsKey(string)) continue;
            deleteKeys.add(string);
        }
        this.effective = this.config.getPropertyNames().size() != 0 && !StringUtils.isBlank((CharSequence)((CharSequence)newDefaultHost.get()));
        this.defaultHost = (String)newDefaultHost.get();
        for (Map.Entry entry : addedMap.entrySet()) {
            this.routeMapHost.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : modifyMap.entrySet()) {
            this.routeMapHost.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : deleteKeys) {
            this.routeMapHost.remove(string);
        }
    }
}

