package com.digiwin.cross.app.command;

import com.digiwin.cross.app.convertor.CallbackTimeoutConvertor;
import com.digiwin.cross.app.dto.request.ConfigCallbackTimeoutRequest;
import com.digiwin.cross.app.dto.request.QueryCallbackTimeoutRequest;
import com.digiwin.cross.app.dto.response.QueryCallbackTimeoutResponse;
import com.digiwin.cross.domain.bo.entity.CallbackTimeoutEntity;
import com.digiwin.cross.domain.service.ICallbackTimeoutService;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.stereotype.Component;

/**
 * @author clay
 * on 2024/9/2
 */
@CommonsLog
@Component
public class CallbackTimeoutCmd {

    private ICallbackTimeoutService callbackTimeoutService;

    public CallbackTimeoutCmd(ICallbackTimeoutService callbackTimeoutService) {
        this.callbackTimeoutService = callbackTimeoutService;
    }

    public void config(ConfigCallbackTimeoutRequest request) {
        CallbackTimeoutEntity callbackTimeoutEntity = CallbackTimeoutConvertor.convertToCallbackTimeoutEntity(request);
        callbackTimeoutService.config(callbackTimeoutEntity);
    }

    public QueryCallbackTimeoutResponse queryCallbackTimeout(QueryCallbackTimeoutRequest request) {
        CallbackTimeoutEntity callbackTimeoutEntity = CallbackTimeoutConvertor.convertToCallbackTimeoutEntity(request);
        CallbackTimeoutEntity queryEntity = callbackTimeoutService.query(callbackTimeoutEntity);
        return CallbackTimeoutConvertor.convertToQueryCallbackTimeoutResponse(queryEntity);
    }
}
