package com.digiwin.cross.app.command;

import com.digiwin.cross.domain.common.LockNamespaceEnum;
import com.digiwin.cross.domain.gateway.IFullAsyncRequestGateway;
import com.digiwin.cross.domain.gateway.ILockGateway;
import com.digiwin.cross.domain.parameter.ApplicationSystemParameter;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author clay
 * on 2024/11/5
 */
@CommonsLog
@Component
public class CleanFullAsyncRequestCmd {

    private static final String TASK_NAME = "cleanFullAsyncRequest";

    private final IFullAsyncRequestGateway fullAsyncRequestGateway;

    private final ILockGateway lockGateway;

    @Autowired
    public CleanFullAsyncRequestCmd (IFullAsyncRequestGateway fullAsyncRequestGateway, ILockGateway lockGateway) {
        this.fullAsyncRequestGateway = fullAsyncRequestGateway;
        this.lockGateway = lockGateway;
    }

    @Scheduled(cron = "0 0 2 * * *")
  //  @PostConstruct
    public void doTask () {
        boolean isLocked = false;
        isLocked = lockGateway.tryLock(LockNamespaceEnum.TASK_LOCK, TASK_NAME, 10, 1 * 3600);
        if (!isLocked) {
            log.info("task is running");
            return;
        }
        try {
            log.info("clean fullAsyncRequest task start");
            fullAsyncRequestGateway.deleteOlderThanDays(ApplicationSystemParameter.LOG_RESERVED_DAY, 5000);

        } catch (Exception e) {
            log.error("clean fullAsyncRequest err", e);
        } finally {
            log.info("clean fullAsyncRequest task finish");
            if (isLocked) {
                lockGateway.unlock(LockNamespaceEnum.TASK_LOCK, TASK_NAME);
            }
        }
    }
}
