package com.digiwin.cross.app.command;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.cross.app.convertor.QueryEaiInfoConvertor;
import com.digiwin.cross.app.dto.EaiDTO;
import com.digiwin.cross.app.dto.response.QueryEaiInfoResponse;
import com.digiwin.cross.infrastructure.database.entity.EaiTenantMappingPO;
import com.digiwin.cross.infrastructure.database.entity.UnionEAIPO;
import com.digiwin.cross.infrastructure.database.mapper.EaiTenantMappingMapper;
import com.digiwin.cross.infrastructure.database.mapper.UnionEaiMapper;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author clay
 * on 2024/8/6
 */
@CommonsLog
@Component
public class QueryEaiInfoCmd {
    private final UnionEaiMapper unionEaiMapper;
    private final EaiTenantMappingMapper eaiTenantMappingMapper;

    @Autowired
    public QueryEaiInfoCmd(UnionEaiMapper unionEaiMapper, EaiTenantMappingMapper eaiTenantMappingMapper) {
        this.unionEaiMapper = unionEaiMapper;
        this.eaiTenantMappingMapper = eaiTenantMappingMapper;
    }

    public QueryEaiInfoResponse execute(String tenantId) {
        EaiTenantMappingPO eaiTenantMappingPO = eaiTenantMappingMapper.selectOne(
                Wrappers.<EaiTenantMappingPO>lambdaQuery()
                        .eq(EaiTenantMappingPO::getTenantId, tenantId));
        if (eaiTenantMappingPO != null) {
            String eaiUid = eaiTenantMappingPO.getEaiUid();

            EaiDTO eaiDTO = null;
            List<String> tenantIdList = null;

            UnionEAIPO unionEAIPO = unionEaiMapper.selectOne(
                    Wrappers.<UnionEAIPO>lambdaQuery()
                            .eq(UnionEAIPO::getUid, eaiUid));

            if (unionEAIPO != null) {
                List<EaiTenantMappingPO> eaiTenantMappingPOList = eaiTenantMappingMapper.selectList(
                        Wrappers.<EaiTenantMappingPO>lambdaQuery()
                                .eq(EaiTenantMappingPO::getEaiUid, eaiUid));

                eaiDTO = QueryEaiInfoConvertor.convertToEaiDTO(unionEAIPO);
                tenantIdList = QueryEaiInfoConvertor.couvertToTenantIdList(eaiTenantMappingPOList);

                QueryEaiInfoResponse response = new QueryEaiInfoResponse();
                response.setEaiDTO(eaiDTO);
                response.setTenantIdList(tenantIdList);
                return response;
            } else {
                return null;
            }

        } else {
            return null;
        }
    }
}
