package com.digiwin.cross.app.command;

import com.digiwin.cross.app.dto.StateCodeDTO;
import com.digiwin.cross.infrastructure.database.entity.StateCodePO;
import com.digiwin.cross.infrastructure.database.mapper.StateCodeMapper;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2023/12/4
 */
@Component
public class StateCodesCmd {
    private StateCodeMapper stateCodeMapper;

    public StateCodesCmd(StateCodeMapper stateCodeMapper) {
        this.stateCodeMapper = stateCodeMapper;
    }

    public List<StateCodeDTO> getStateCodes() {
        List<StateCodePO> stateCodePOList = stateCodeMapper.selectList(null);

        return stateCodePOList.stream().map(StateCodeDTO::new).collect(Collectors.toList());
    }
}
