package com.digiwin.cross.app.dto;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: eai映射Mapping对象
 * add by songwq
 * 针对集成中心开放接口 story-view-48716
 * @author: songwq
 * @date: 2025/7/15
 */
@Getter
@Setter
public class EaiMappingDTO {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * ip
     */
    private String ip;

    /**
     * 唯一d（可设定）
     */
    private String uid;

    /**
     * 备注（通过前缀区分类型）
     */
    private String remark;

    /**
     * 中台对应的租户
     */
    private List<TenantInfo> tenant_list;

    /**
     * 网关ID
     */
    private String gateway_id;

    /**
     * 网关名称
     */
    private String gateway_name;

    /**
     * 构建时间
     */
    private Date buildTime;

    /**
     * 最后一次更新时间
     */
    private Date lastUpdateTime;

    /**
     * 类型
     * 0：数环通
     * 1：幂链
     * 2：CROSS
     */
    private String type;

    /**
     * 状态
     * 0：离线
     * 1：在线
     */
    private String status;

    @Setter
    @Getter
    public static class TenantInfo {

        private String tenant_name;

        private String tenant_id;
    }

    /**
     * 添加租户到集合中
     * @param tenantId
     */
    public void addTenant(String tenantId, String tenantName){
        if (CollectionUtils.isEmpty(tenant_list)) {
            tenant_list = new ArrayList<>();
        }
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenant_id(tenantId);
        tenantInfo.setTenant_name(tenantName);
        tenant_list.add(tenantInfo);
    }

}
