package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.UnionProductDTO;
import com.digiwin.cross.domain.state.StateEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @description: 地端产品列表响应对象
 * add by songwq 20250715
 * 针对集成中心开放接口 story-view-48716
 * @author: songwq
 * @date: 2025/7/15 10:04
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class GetUnionProdListResponse extends BaseResponse {

    private List<UnionProductDTO> prod;

    public GetUnionProdListResponse(StateEnum stateEnum, List<UnionProductDTO> prods) {
        super.setState(stateEnum);
        this.prod = prods;
    }
}
