package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.EaiMappingDTO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Getter;
import lombok.Setter;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * @author songwq
 * on 2025/07/14
 * 地端清单响应对象
 * add by songwq 20250715
 * 针对集成中心开放接口 story-view-48716
 */
@Getter
@Setter
public class QueryEaiListResponse {
    @JsonProperty("data")
    private List<EaiMappingDTO> eaiDTOs;

    @JsonProperty("code")
    private Integer code;

    @JsonProperty("message")
    private String message;

    @JsonProperty("total")
    private Long total;

    public Response toResponse() {
        ObjectNode tObjectNode = JsonUtil.createJsonObject();
        return Response.ok(JsonUtil.toJson(this), MediaType.APPLICATION_JSON).build();
    }

}
