package com.digiwin.cross.app.dto.response;

import com.digiwin.cross.app.dto.EaiLogDTO;
import com.digiwin.cross.domain.utils.JsonUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * @author clay
 * on 2023/12/8
 */
@Getter
@Setter
@Builder
public class QueryEaiLogsResponse {
    int code;
    String description;
    List<EaiLogDTO> logs;

    public Response toResponse() {
        ObjectNode tObjectNode = JsonUtil.createJsonObject();
        ObjectNode tExceptionNode = tObjectNode.putObject("execution");
        tExceptionNode.put("code", String.valueOf(code));
        tExceptionNode.put("description", StringUtils.defaultString(description, ""));

        tObjectNode.set("logs", JsonUtil.getMAPPER().valueToTree(logs));
        return Response.ok(JsonUtil.toJson(tObjectNode), MediaType.APPLICATION_JSON).build();
    }
}
